﻿/*
Copyright (c) 2003-2024, CKSource Holding sp. z o.o. All rights reserved.
For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license/
*/
CKEDITOR.lang['ca']={"application":"Rich Text Editor","editor":"Editor de text enriquit","editorPanel":"Panell de l'editor de text enriquit","common":{"editorHelp":"Premeu ALT 0 per ajuda","browseServer":"Veure servidor","url":"URL","protocol":"Protocol","upload":"Puja","uploadSubmit":"Envia-la al servidor","image":"Imatge","form":"Formulari","checkbox":"Casella de verificació","radio":"Botó d'opció","textField":"Camp de text","textarea":"Àrea de text","hiddenField":"Camp ocult","button":"Botó","select":"Camp de selecció","imageButton":"Botó d'imatge","notSet":"<no definit>","id":"Id","name":"Nom","langDir":"Direcció de l'idioma","langDirLtr":"D'esquerra a dreta (LTR)","langDirRtl":"De dreta a esquerra (RTL)","langCode":"Codi d'idioma","longDescr":"Descripció llarga de la URL","cssClass":"Classes del full d'estil","advisoryTitle":"Títol consultiu","cssStyle":"Estil","ok":"D'acord","cancel":"Cancel·la","close":"Tanca","preview":"Previsualitza","resize":"Arrossegueu per redimensionar","generalTab":"General","advancedTab":"Avançat","validateNumberFailed":"Aquest valor no és un número.","confirmNewPage":"Els canvis en aquest contingut que no es desin es perdran. Esteu segur que voleu carregar una pàgina nova?","confirmCancel":"Algunes opcions s'han canviat. Esteu segur que voleu tancar el quadre de diàleg?","options":"Opcions","target":"Destí","targetNew":"Nova finestra (_blank)","targetTop":"Finestra superior (_top)","targetSelf":"Mateixa finestra (_self)","targetParent":"Finestra pare (_parent)","langDirLTR":"D'esquerra a dreta (LTR)","langDirRTL":"De dreta a esquerra (RTL)","styles":"Estil","cssClasses":"Classes del full d'estil","width":"Amplada","height":"Alçada","align":"Alineació","left":"Ajusta a l'esquerra","right":"Ajusta a la dreta","center":"Centre","justify":"Justificat","alignLeft":"Alinea a l'esquerra","alignRight":"Alinea a la dreta","alignCenter":"Align Center","alignTop":"Superior","alignMiddle":"Centre","alignBottom":"Inferior","alignNone":"Cap","invalidValue":"Valor no vàlid.","invalidHeight":"L'alçada ha de ser un número.","invalidWidth":"L'amplada ha de ser un número.","invalidLength":"Value specified for the \"%1\" field must be a positive number with or without a valid measurement unit (%2).","invalidCssLength":"El valor especificat per als \"%1\" camps ha de ser un número positiu amb o sense unitat de mesura vàlida de CSS (px, %, in, cm, mm, em, ex, pt o pc).","invalidHtmlLength":"El valor especificat per als \"%1\" camps ha de ser un número positiu amb o sense unitat de mesura vàlida d'HTML (px o %).","invalidInlineStyle":"El valor especificat per l'estil en línia ha de constar d'una o més tuples amb el format \"name: value\", separats per punt i coma.","cssLengthTooltip":"Introduïu un número per un valor en píxels o un número amb una unitat vàlida de CSS (px, %, in, cm, mm, em, ex, pt o pc).","unavailable":"%1<span class=\"cke_accessibility\">, no disponible</span>","keyboard":{"8":"Retrocés","13":"Intro","16":"Majúscules","17":"Ctrl","18":"Alt","32":"Space","35":"Fi","36":"Inici","46":"Eliminar","112":"F1","113":"F2","114":"F3","115":"F4","116":"F5","117":"F6","118":"F7","119":"F8","120":"F9","121":"F10","122":"F11","123":"F12","124":"F13","125":"F14","126":"F15","127":"F16","128":"F17","129":"F18","130":"F19","131":"F20","132":"F21","133":"F22","134":"F23","135":"F24","224":"Command"},"keyboardShortcut":"Keyboard shortcut","optionDefault":"Default"},"versionCheck":{"notificationMessage":"This CKEditor %current version is not secure. Consider <a target=\"_blank\" href=\"%link\">upgrading to the latest one</a>, %latest.","consoleMessage":"This CKEditor %current version is not secure. Consider upgrading to the latest one, %latest: %link","aboutDialogInsecureMessage":"This CKEditor %current version is not secure.<br>Consider upgrading to the latest one, %latest:<br><a target=\"_blank\" href=\"%link\">%link</a>","aboutDialogUpgradeMessage":"Consider upgrading to the latest editor version, %latest:<br><a target=\"_blank\" href=\"%link\">%link</a>"},"about":{"copy":"Copyright &copy; $1. Tots els drets reservats.","dlgTitle":"Quant al CKEditor 4","moreInfo":"Per informació sobre llicències visiteu el nostre lloc web:"},"basicstyles":{"bold":"Negreta","italic":"Cursiva","strike":"Ratllat","subscript":"Subíndex","superscript":"Superíndex","underline":"Subratllat"},"bidi":{"ltr":"Direcció del text d'esquerra a dreta","rtl":"Direcció del text de dreta a esquerra"},"blockquote":{"toolbar":"Bloc de cita"},"notification":{"closed":"Notificació tancada."},"toolbar":{"toolbarCollapse":"Redueix la barra d'eines","toolbarExpand":"Amplia la barra d'eines","toolbarGroups":{"document":"Document","clipboard":"Clipboard/Undo","editing":"Editing","forms":"Forms","basicstyles":"Basic Styles","paragraph":"Paragraph","links":"Links","insert":"Insert","styles":"Styles","colors":"Colors","tools":"Tools"},"toolbars":"Editor de barra d'eines"},"clipboard":{"copy":"Copiar","copyError":"La configuració de seguretat del vostre navegador no permet executar automàticament les operacions de copiar. Si us plau, utilitzeu el teclat (Ctrl/Cmd+C).","cut":"Retallar","cutError":"La configuració de seguretat del vostre navegador no permet executar automàticament les operacions de retallar. Si us plau, utilitzeu el teclat (Ctrl/Cmd+X).","paste":"Enganxar","pasteNotification":"Press %1 to paste. Your browser doesn‘t support pasting with the toolbar button or context menu option.","pasteArea":"Àrea d'enganxat","pasteMsg":"Paste your content inside the area below and press OK.","fileFormatNotSupportedNotification":"The ${formats} file format(s) are not supported.","fileWithoutFormatNotSupportedNotification":"The file format is not supported."},"colorbutton":{"auto":"Automàtic","bgColorTitle":"Color de Fons","colors":{"000":"Negre","800000":"Grana","8B4513":"Marró sella","2F4F4F":"Gris pissarra fosca","008080":"Blau xarxet","000080":"Blau marí","4B0082":"Indi","696969":"Gris Fosc","B22222":"Foc Maó","A52A2A":"Marró","DAA520":"Solidago","006400":"Verd Fosc","40E0D0":"Turquesa","0000CD":"Blau 1/2","800080":"Lila","808080":"Gris","F00":"Vermell","FF8C00":"Taronja Fosc","FFD700":"Or","008000":"Verd","0FF":"Cian","00F":"Blau","EE82EE":"Violat","A9A9A9":"Gris clar","FFA07A":"Salmó clar","FFA500":"Taronja","FFFF00":"Groc","00FF00":"Verd Llima","AFEEEE":"Turquesa Pàl·lid","ADD8E6":"Blau Clar","DDA0DD":"Pruna","D3D3D3":"Gris Clar","FFF0F5":"Lavanda rosat","FAEBD7":"Blanc Antic","FFFFE0":"Groc Clar","F0FFF0":"Verd Pàl·lid","F0FFFF":"Atzur","F0F8FF":"Cian pàlid","E6E6FA":"Lavanda","FFF":"Blanc","1ABC9C":"Strong Cyan","2ECC71":"Emerald","3498DB":"Bright Blue","9B59B6":"Amethyst","4E5F70":"Grayish Blue","F1C40F":"Vivid Yellow","16A085":"Dark Cyan","27AE60":"Dark Emerald","2980B9":"Strong Blue","8E44AD":"Dark Violet","2C3E50":"Desaturated Blue","F39C12":"Orange","E67E22":"Carrot","E74C3C":"Pale Red","ECF0F1":"Bright Silver","95A5A6":"Light Grayish Cyan","DDD":"Light Gray","D35400":"Pumpkin","C0392B":"Strong Red","BDC3C7":"Silver","7F8C8D":"Grayish Cyan","999":"Dark Gray"},"more":"Més Colors...","panelTitle":"Colors","textColorTitle":"Color del Text"},"colordialog":{"clear":"Neteja","highlight":"Destacat","options":"Opcions del color","selected":"Color Seleccionat","title":"Seleccioni el color"},"templates":{"button":"Plantilles","emptyListMsg":"(No hi ha plantilles definides)","insertOption":"Reemplaça el contingut actual","options":"Opcions de plantilla","selectPromptMsg":"Seleccioneu una plantilla per usar a l'editor<br>(per defecte s'elimina el contingut actual):","title":"Plantilles de contingut"},"contextmenu":{"options":"Opcions del menú contextual"},"copyformatting":{"label":"Copy Formatting","notification":{"copied":"Formatting copied","applied":"Formatting applied","canceled":"Formatting canceled","failed":"Formatting failed. You cannot apply styles without copying them first."}},"div":{"IdInputLabel":"Id","advisoryTitleInputLabel":"Títol de guia","cssClassInputLabel":"Classes de la fulla d'estils","edit":"Edita la Capa","inlineStyleInputLabel":"Estil en línia","langDirLTRLabel":"D'esquerra a dreta (LTR)","langDirLabel":"Direcció de l'idioma","langDirRTLLabel":"De dreta a esquerra (RTL)","languageCodeInputLabel":" Codi d'idioma","remove":"Elimina la Capa","styleSelectLabel":"Estil","title":"Crea una Capa Contenidora","toolbar":"Crea una Capa Contenidora"},"elementspath":{"eleLabel":"Ruta dels elements","eleTitle":"%1 element"},"exportpdf":{"documentReady":"Document is ready!","error":"Error occurred.","processingDocument":"Processing PDF document...","toolbar":"Export to PDF"},"filetools":{"loadError":"S'ha produït un error durant la lectura del fitxer.","networkError":"S'ha produït un error de xarxa durant la càrrega del fitxer.","httpError404":"S'ha produït un error HTTP durant la càrrega del fitxer (404: Fitxer no trobat).","httpError403":"S'ha produït un error HTTP durant la càrrega del fitxer (403: Permís denegat).","httpError":"S'ha produït un error HTTP durant la càrrega del fitxer (estat d'error: %1).","noUrlError":"La URL de càrrega no està definida.","responseError":"Resposta incorrecte del servidor"},"find":{"find":"Cerca","findOptions":"Opcions de Cerca","findWhat":"Cerca el:","matchCase":"Distingeix majúscules/minúscules","matchCyclic":"Coincidència cíclica","matchWord":"Només paraules completes","notFoundMsg":"El text especificat no s'ha trobat.","replace":"Reemplaça","replaceAll":"Reemplaça-ho tot","replaceSuccessMsg":"%1 ocurrència/es reemplaçada/es.","replaceWith":"Reemplaça amb:","title":"Cerca i reemplaça"},"font":{"fontSize":{"label":"Mida","voiceLabel":"Mida de la lletra","panelTitle":"Mida de la lletra"},"label":"Tipus de lletra","panelTitle":"Tipus de lletra","voiceLabel":"Tipus de lletra"},"fakeobjects":{"anchor":"Àncora","hiddenfield":"Camp ocult","iframe":"IFrame","unknown":"Objecte desconegut"},"forms":{"button":{"title":"Propietats del botó","text":"Text (Valor)","type":"Tipus","typeBtn":"Botó","typeSbm":"Transmet formulari","typeRst":"Reinicia formulari"},"checkboxAndRadio":{"checkboxTitle":"Propietats de la casella de verificació","radioTitle":"Propietats del botó d'opció","value":"Valor","selected":"Seleccionat","required":"Necessari"},"form":{"title":"Propietats del formulari","menu":"Propietats del formulari","action":"Acció","method":"Mètode","encoding":"Codificació"},"hidden":{"title":"Propietats del camp ocult","name":"Nom","value":"Valor"},"select":{"title":"Propietats del camp de selecció","selectInfo":"Info","opAvail":"Opcions disponibles","value":"Valor","size":"Mida","lines":"Línies","chkMulti":"Permet múltiples seleccions","required":"Necessari","opText":"Text","opValue":"Valor","btnAdd":"Afegeix","btnModify":"Modifica","btnUp":"Amunt","btnDown":"Avall","btnSetValue":"Selecciona per defecte","btnDelete":"Elimina"},"textarea":{"title":"Propietats de l'àrea de text","cols":"Columnes","rows":"Files"},"textfield":{"title":"Propietats del camp de text","name":"Nom","value":"Valor","charWidth":"Amplada","maxChars":"Nombre màxim de caràcters","required":"Necessari","type":"Tipus","typeText":"Text","typePass":"Contrasenya","typeEmail":"Correu electrònic","typeSearch":"Cercar","typeTel":"Número de telèfon","typeUrl":"URL"}},"format":{"label":"Format","panelTitle":"Format","tag_address":"Adreça","tag_div":"Normal (DIV)","tag_h1":"Encapçalament 1","tag_h2":"Encapçalament 2","tag_h3":"Encapçalament 3","tag_h4":"Encapçalament 4","tag_h5":"Encapçalament 5","tag_h6":"Encapçalament 6","tag_p":"Normal","tag_pre":"Formatejat"},"horizontalrule":{"toolbar":"Insereix línia horitzontal"},"iframe":{"border":"Mostra la vora del marc","noUrl":"Si us plau, introdueixi la URL de l'iframe","scrolling":"Activa les barres de desplaçament","title":"Propietats de l'IFrame","toolbar":"IFrame","tabindex":"Remove from tabindex"},"image":{"alt":"Text alternatiu","border":"Vora","btnUpload":"Envia-la al servidor","button2Img":"Voleu transformar el botó d'imatge seleccionat en una simple imatge?","hSpace":"Espaiat horit.","img2Button":"Voleu transformar la imatge seleccionada en un botó d'imatge?","infoTab":"Informació de la imatge","linkTab":"Enllaç","lockRatio":"Bloqueja les proporcions","menu":"Propietats de la imatge","resetSize":"Restaura la mida","title":"Propietats de la imatge","titleButton":"Propietats del botó d'imatge","upload":"Puja","urlMissing":"Falta la URL de la imatge.","vSpace":"Espaiat vert.","validateBorder":"La vora ha de ser un nombre enter.","validateHSpace":"HSpace ha de ser un nombre enter.","validateVSpace":"VSpace ha de ser un nombre enter."},"indent":{"indent":"Augmenta el sagnat","outdent":"Redueix el sagnat"},"smiley":{"options":"Opcions d'emoticones","title":"Insereix una icona","toolbar":"Icona"},"language":{"button":"Definir l'idioma","remove":"Eliminar idioma"},"link":{"acccessKey":"Clau d'accés","advanced":"Avançat","advisoryContentType":"Tipus de contingut consultiu","advisoryTitle":"Títol consultiu","anchor":{"toolbar":"Insereix/Edita àncora","menu":"Propietats de l'àncora","title":"Propietats de l'àncora","name":"Nom de l'àncora","errorName":"Si us plau, escriviu el nom de l'ancora","errorWhitespace":"Anchor name cannot contain space characters","remove":"Remove Anchor"},"anchorId":"Per Id d'element","anchorName":"Per nom d'àncora","charset":"Conjunt de caràcters font enllaçat","cssClasses":"Classes del full d'estil","download":"Force Download","displayText":"Text a mostrar","emailAddress":"Adreça de correu electrònic","emailBody":"Cos del missatge","emailSubject":"Assumpte del missatge","id":"Id","info":"Informació de l'enllaç","langCode":"Direcció de l'idioma","langDir":"Direcció de l'idioma","langDirLTR":"D'esquerra a dreta (LTR)","langDirRTL":"De dreta a esquerra (RTL)","menu":"Edita l'enllaç","name":"Nom","noAnchors":"(No hi ha àncores disponibles en aquest document)","noEmail":"Si us plau, escrigui l'adreça correu electrònic","noUrl":"Si us plau, escrigui l'enllaç URL","noTel":"Please type the phone number","other":"<altre>","phoneNumber":"Phone number","popupDependent":"Depenent (Netscape)","popupFeatures":"Característiques finestra popup","popupFullScreen":"Pantalla completa (IE)","popupLeft":"Posició esquerra","popupLocationBar":"Barra d'adreça","popupMenuBar":"Barra de menú","popupResizable":"Redimensionable","popupScrollBars":"Barres d'scroll","popupStatusBar":"Barra d'estat","popupToolbar":"Barra d'eines","popupTop":"Posició dalt","rel":"Relació","selectAnchor":"Selecciona una àncora","styles":"Estil","tabIndex":"Index de Tab","target":"Destí","targetFrame":"<marc>","targetFrameName":"Nom del marc de destí","targetPopup":"<finestra emergent>","targetPopupName":"Nom finestra popup","title":"Enllaç","toAnchor":"Àncora en aquesta pàgina","toEmail":"Correu electrònic","toUrl":"URL","toPhone":"Phone","toolbar":"Insereix/Edita enllaç","type":"Tipus d'enllaç","unlink":"Elimina l'enllaç","upload":"Puja"},"list":{"bulletedlist":"Llista de pics","numberedlist":"Llista numerada"},"liststyle":{"bulletedTitle":"Bulleted List Properties","circle":"Circle","decimal":"Decimal (1, 2, 3, etc.)","disc":"Disc","lowerAlpha":"Lower Alpha (a, b, c, d, e, etc.)","lowerRoman":"Lower Roman (i, ii, iii, iv, v, etc.)","none":"None","notset":"<not set>","numberedTitle":"Numbered List Properties","square":"Square","start":"Start","type":"Type","upperAlpha":"Upper Alpha (A, B, C, D, E, etc.)","upperRoman":"Upper Roman (I, II, III, IV, V, etc.)","validateStartNumber":"List start number must be a whole number."},"magicline":{"title":"Insereix el paràgraf aquí"},"maximize":{"maximize":"Maximitza","minimize":"Minimitza"},"newpage":{"toolbar":"Nova pàgina"},"pagebreak":{"alt":"Salt de pàgina","toolbar":"Insereix salt de pàgina"},"pastetext":{"button":"Enganxa com a text no formatat","pasteNotification":"Press %1 to paste. Your browser doesn‘t support pasting with the toolbar button or context menu option.","title":"Enganxa com a text no formatat"},"pastefromword":{"confirmCleanup":"El text que voleu enganxar sembla provenir de Word. Voleu netejar aquest text abans que sigui enganxat?","error":"No ha estat possible netejar les dades enganxades degut a un error intern","title":"Enganxa des del Word","toolbar":"Enganxa des del Word"},"preview":{"preview":"Visualització prèvia"},"print":{"toolbar":"Imprimeix"},"removeformat":{"toolbar":"Elimina Format"},"save":{"toolbar":"Desa"},"selectall":{"toolbar":"Selecciona-ho tot"},"showblocks":{"toolbar":"Mostra els blocs"},"sourcearea":{"toolbar":"Codi font"},"specialchar":{"options":"Opcions de caràcters especials","title":"Selecciona el caràcter especial","toolbar":"Insereix caràcter especial"},"scayt":{"btn_about":"Quant a l'SCAYT","btn_dictionaries":"Diccionaris","btn_disable":"Deshabilita SCAYT","btn_enable":"Habilitat l'SCAYT","btn_langs":"Idiomes","btn_options":"Opcions","text_title":"Spell Check As You Type"},"stylescombo":{"label":"Estil","panelTitle":"Estils de format","panelTitle1":"Estils de bloc","panelTitle2":"Estils incrustats","panelTitle3":"Estils d'objecte"},"table":{"border":"Mida vora","caption":"Títol","cell":{"menu":"Cel·la","insertBefore":"Insereix abans","insertAfter":"Insereix després","deleteCell":"Suprimeix","merge":"Fusiona","mergeRight":"Fusiona a la dreta","mergeDown":"Fusiona avall","splitHorizontal":"Divideix horitzontalment","splitVertical":"Divideix verticalment","title":"Propietats de la cel·la","cellType":"Tipus de cel·la","rowSpan":"Expansió de files","colSpan":"Expansió de columnes","wordWrap":"Ajustar al contingut","hAlign":"Alineació Horizontal","vAlign":"Alineació Vertical","alignBaseline":"A la línia base","bgColor":"Color de fons","borderColor":"Color de la vora","data":"Dades","header":"Capçalera","columnHeader":"Column Header","rowHeader":"Row Header","yes":"Sí","no":"No","invalidWidth":"L'amplada de cel·la ha de ser un nombre.","invalidHeight":"L'alçada de cel·la ha de ser un nombre.","invalidRowSpan":"L'expansió de files ha de ser un nombre enter.","invalidColSpan":"L'expansió de columnes ha de ser un nombre enter.","chooseColor":"Trieu"},"cellPad":"Encoixinament de cel·les","cellSpace":"Espaiat de cel·les","column":{"menu":"Columna","insertBefore":"Insereix columna abans de","insertAfter":"Insereix columna darrera","deleteColumn":"Suprimeix una columna"},"columns":"Columnes","deleteTable":"Suprimeix la taula","headers":"Capçaleres","headersBoth":"Ambdues","headersColumn":"Primera columna","headersNone":"Cap","headersRow":"Primera fila","heightUnit":"height unit","invalidBorder":"El gruix de la vora ha de ser un nombre.","invalidCellPadding":"L'encoixinament de cel·la  ha de ser un nombre.","invalidCellSpacing":"L'espaiat de cel·la  ha de ser un nombre.","invalidCols":"El nombre de columnes ha de ser un nombre major que 0.","invalidHeight":"L'alçada de la taula  ha de ser un nombre.","invalidRows":"El nombre de files ha de ser un nombre major que 0.","invalidWidth":"L'amplada de la taula  ha de ser un nombre.","menu":"Propietats de la taula","row":{"menu":"Fila","insertBefore":"Insereix fila abans de","insertAfter":"Insereix fila darrera","deleteRow":"Suprimeix una fila"},"rows":"Files","summary":"Resum","title":"Propietats de la taula","toolbar":"Taula","widthPc":"percentatge","widthPx":"píxels","widthUnit":"unitat d'amplada"},"undo":{"redo":"Refés","undo":"Desfés"},"widget":{"move":"Clicar i arrossegar per moure","label":"%1 widget"},"uploadwidget":{"abort":"Pujada cancel·lada per l'usuari.","doneOne":"Fitxer pujat correctament.","doneMany":"%1 fitxers pujats correctament.","uploadOne":"Pujant fitxer ({percentage}%)...","uploadMany":"Pujant fitxers, {current} de {max} finalitzats ({percentage}%)..."},"a11yfirsthelp":{"label":"A11yFirst Help","panelTitle":"Learn about A11yFirst features","keyboardShortcutsLabel":"Keyboard Shortcuts","versionLabel":"Version","a11yFirstHelpLabel":"A11yFirst Help: Content Accessibility","a11yFirstHelpTitle":"Information to help authors understand how the A11yFirst features help them make content more accessible to people with disabilites","headingHelp":{"menu":"Heading / Paragraph","label":"Heading / Paragraph","title":"Heading / Paragraph Help","content":"## Heading / Paragraph\n\n### Menu items\n* **H1 – Document title** — Typically should be the first heading in the\n  document and used only once.\n* **H2 – Section title** — Describes a main or top-level section in the\n  document.\n* **H3 to H6 – Subsection title** — Describes a subsection within a top-level\n  section or other subsection of the document.\n* **Normal** — The default paragraph format, typically with significant top\n  and bottom margins.\n* **Preformatted text** — Use this for computer code blocks to maintain spacing\n  and indentation.\n* **Address line** — Use this to type a series of address lines styled in\n  italics and with minimal top and bottom margins. When you press enter at the\n  end of a line, the next line is also an address line.\n\n### About headings\n* The Heading / Paragraph menu only enables the **allowed** heading levels.\n\n* The cursor position relative to other headings in the document determines\nwhich heading levels are allowed.\n\n### About paragraph formats\n* Visual styling for paragraph formats is predetermined by your organization,\nthus freeing up your time and energy for concentrating on the structure and\nmeaning of the content within your document.\n\n### Why headings and paragraph formats are important\n* The purpose of a heading is to label the content that follows it.\n\n* The proper nesting of heading levels improves the ability of all users to\nfind and comprehend information on a page.\n\n* Headings used consistently and in meaningful ways improve Search Engine\nOptimization (SEO).\n\n* Properly nested headings enable people using assistive technologies to easily\nnavigate to each section of a document.\n\n* When paragraph formats are used properly (e.g. *Preformatted* or *Address*),\nthey help users of assistive technologies understand the intended role of the\ncontent.\n\n* Thinking in terms of blocks such as headings and paragraph formats within\nyour document is a higher-level approach to providing structure and semantics\nthat are important for all users.\n\n### More information\n* Documents are easier to read and understand when headings identify the topics\nthey contain.\n\n* Headings make it easier to scan and find topics of interest within a document.\n\n* Heading levels identify the structural relationships between sections of\ncontent in a document.\n\n* Higher-level headings (Levels 1 and 2) identify the main topics of a document\nand lower-level headings (Levels 3, 4, 5 and 6) identify subsections of the\ndocument.\n\n* A subsection is identified by using the next lower-level heading. For\nexample, subsections of Level 2 headings use Level 3 headings, subsections of\nLevel 3 headings use Level 4 headings, and so on to Level 6 headings.\n\n* Break content into subsections when there are two or more ideas or concepts\nthat correspond to the topics covered in the section. Use headings of the same\nlevel to label each subsection.\n\n* Heading levels should **never** be used for inline visual styling of content\n(e.g. larger or smaller font size, bold or italic). Instead, use the `Inline\nStyle` options.\n"},"listHelp":{"menu":"List","label":"List","title":"List Help","content":"## List\n\n### Working with lists\n\n<img style=\"padding: 8px 0 3px 5px\" alt=\"list toolbar buttons\"\nsrc=\"basePath/plugins/a11yfirsthelp/images/list-buttons.png\"/>\n\nUse the toolbar buttons shown above to:\n\n* Insert/Remove Numbered List\n* Insert/Remove Bulleted List\n* Increase Indent\n* Decrease Indent\n\n### List properties via context menu\n\nThe context menu allows further configuration of list properties such as\nnumbering and bullet types by selecting:\n\n* Numbered List Properties\n* Bulleted List Properties\n\nThe context menu can be invoked by positioning the cursor in a list item and:\n\n* right-clicking, using the mouse, or\n* using Mouse Keys on Windows or Mac.\n\n### About lists\n\n* Use a numbered list when the order or sequence of the items is significant.\n* Use a bulleted list when the order of the items is not significant.\n\n### Why lists are important\n\n* Lists convey grouping semantics for related items.\n* Lists may also convey hierarchical structure.\n* When related items are grouped as a list, information about the list is\n  conveyed to screen reader users, including the type of list, the number of\n  items it contains and the sequence number of the current list item.\n"},"imageHelp":{"menu":"Image","label":"Image","title":"Image Help","content":"## Image\n\n### Accessible image descriptions\n\n* People with visual impairments or visual processing disorders need\n  accessible text descriptions of informative images.\n\n* There are two types of accessible descriptions for images: *alternative\n  text* and *long descriptions*.\n\n### Alternative text\n\n* Succinctly describes the content and function of the image for people\n  with visual impairments, in no more than 100 characters\n\n* Is required for informative images (but not for images that are purely\n  decorative)\n\n* Is not visible in the document; it is communicated to screen reader users\n  via the *img* element's *alt* attribute\n\n* For a purely decorative image, select the **‘Image does not require\n  alternative text’** checkbox and leave the alternative text field blank.\n\n### Long descriptions for complex images\n\n* A complex image has informational content that cannot be described adequately\n  by alternative text of 100 characters or less.\n\n* Examples of complex images include charts, graphs, diagrams, scientific\n  photographs and works of art.\n\n* A complex image needs both a concise alternative text description and a\n  longer, more detailed description.\n\n* Accessibility requirements mandate that the long description of a complex\n  image be placed in the document adjacent to the image.\n\n### Adding a long description in the document\n\nFollow these steps when adding a long description of a complex image:\n\n1. Add an adequately detailed description of the image within the document,\n   either just before or after the image (or both).\n\n1. In answer to the question **‘Is a long description needed, and if so,\n   where will it be located’**, select one of the following:\n       * Yes; in the document before the image\n       * Yes; in the document after the image\n       * Yes; in the document before and after the image\n\nBy specifying the location of the long description relative to the image,\nscreen reader users will be informed of its existence and location in the\ndocument. (This information is appended to the alternative text.)\n\n### Insert a caption text box below the image\n\n* A **caption** is an optional visual label supported by CKEditor for an image.\n  It provides an additional way to describe an image that is immediately below\n  and proximate to the image.\n\n* The caption content is specified and is editable in the text box just below\n  the image, once it has been inserted in the document.\n\n* From an accessibility perspective the *caption* and the *alternative text*\n  should not be the same, but instead should complement each other.\n\n* Using the caption creates a *figcaption* element contained in a *figure*\n  element. The *figure* element also contains the *img* element.\n\n### Writing effective alternative text\n\nThe following are based on <a href=\"https://webaim.org\" target=\"_resource\">\nWebAIM</a>'s guidelines for alternative text:\n\n* **Be accurate and equivalent** in presenting the same *content* and\n  *function* of the image.\n\n* When **images are used as links**, the alternative text should describe the\n  target of the link.\n\n* **Be succinct.** This means the correct content and function of the image\n  should be presented as succinctly as is appropriate. Typically no more than\n  a few words are necessary, though rarely a short sentence or two may be\n  appropriate. The length should not exceed 100 characters.\n\n* **Do NOT be redundant** or provide the same information as text that is\n  already part of the document.\n\n* **Do NOT use the phrases “image of ...” or “graphic of ...”** to describe\n  the image. Assistive technologies notify the user of the image.  It is your\n  job to describe the purpose or the content of the image.  If the image is a\n  photograph or illustration, etc. of important content, it may be useful to\n  include this in the alternative text.\n\n* **Do NOT include file names or sizes** as part of the alternative text.\n\n### Why image descriptions are important\n\nAdding text descriptions of images is an important part of making documents\naccessible to the visually impaired who use assistive devices such as screen\nreaders and magnifiers, and to people with visual processing disorders, which\nmake especially complex images more difficult to understand.\n\nWhen the user cannot see all or part of an image, assistive technologies will\nread or display its alternative text description. This is especially important\nwhen the image conveys information that is required for the user to fully\nunderstand the information in the document.\n\nFor people with visual processing disorders, a detailed description of a\ncomplex image helps them to more quickly or completely understand the\ninformation being conveyed by the image.\n\n### More information\n\n* <a href=\"https://accessibility.psu.edu/images/alttext/\"\ntarget=\"_resource\">Penn State: Image ALT Text</a>\n\n* <a href=\"https://webaim.org/techniques/alttext/\"\ntarget=\"_resource\">WebAIM: Alternative Text</a>\n\n* <a href=\"https://www.w3.org/WAI/tutorials/images/\"\ntarget=\"_resource\">W3C Web Accessibility Image Tutorial</a>\n\n* <a href=\"http://diagramcenter.org/\" target=\"_resource\">Diagram Center</a>\n"},"inlineStyleHelp":{"menu":"Character Style","label":"Character Style","title":"Character Style Help","content":"## Character Style\n\n### Working with character styles\n\n* To apply a character style to existing text, select a range of text and then\nchoose an option from the menu.\n\n* To apply a character style to text you are about to type, choose an option\nfrom the menu and begin typing. The style will continue to be applied until\nyou choose another option or move the cursor to a different point in the\ndocument.\n\n* Multiple character styles can be applied to selected text.\n\n### About character styles\n\n* Character styles have a different purpose than paragraph formats. They are\nused at a lower level to highlight words or phrases within blocks of text.\n\n* Character styles, when used properly, help screen reader users better\nunderstand the types and meanings of lower-level stylistic changes within\nblocks of text.\n\n### Character styles vs. headings, lists and paragraph formats\n\n* Thinking in terms of headings, lists and paragraph formats first, and then\nusing character styles to emphasize key words or phrases within text blocks,\nresults in documents that are easier to read and understand.\n\n* When headings, lists and paragraph formats are considered as primary, and\ncharacter styles secondary, many visual styling decisions can be avoided, as\nthey are already made by default.\n\n* When character styles are used to change the styling of blocks of text\nwithout regard to whether the block is a heading, list item or other type of\nparagraph format, it makes the document more difficult to read and understand\nwithin the context of the website.\n\n* Using headings, lists, paragraph formats and character styles properly will\nmake it easier for you to maintain stylistic consistency.\n"},"linkHelp":{"menu":"Link","label":"Link","title":"Link Help","content":"## Link\n\n### Display Text\n\nProviding accessible *Display Text* is straightforward if you keep the\nfollowing guidelines in mind:\n\n1. The *Display Text* for a link should describe the target of the link.\n\n1. Do not use ambiguous text, such as “Click Here” or “More”.\n\n1. Do not begin the *Display Text* with redundant words or phrases such as\n   “Link” or “Link to”.\n\n1. Be consistent: Links to the same URL or e-mail address should have the same\n   *Display Text*.\n\n1. In most cases, it is best not to use the link URL or e-mail address as the\n   *Display Text*.\n\n### About links\n\n* Screen reader users often use the “List of Links” feature to identify and\n  navigate to links on a page. When links are presented as a list,  using\n  descriptive *Display Text* becomes even more important since understanding\n  the target of each link no longer benefits from its original context within\n  the document.\n\n* Screen reader users often use the “Search” feature to find links on a page\n  based on keywords they would expect to find in the *Display Text* of the\n  links. Thus the more descriptive the link *Display Text*, the more effective\n  the search feature will be in finding relevant links.\n\n* Usable and accessible *Display Text* should be descriptive, unique and start\n  with keywords (NNG).\n\n* The *Display Text* for links is like a sign post. It should tell you what\n  you’ll find when you follow it (NOMENSA).\n\n### Why links are important\n\n* Descriptive link text makes it easier for everyone to find and follow links\n  on a page that are of interest to them.\n\n* Descriptive link text is especially important for people using screen\n  readers, who typically only hear the display text spoken to them through\n  speech synthesis and do not \"see\" the link in the context of other content\n  on the page.\n\n* When URLs, e-mail addresses or other ambiguous text are used as the display\n  text for a link, it is impossible in many cases, and much more difficult in\n  the remaining cases, for screen reader users to find and follow links of\n  interest to them.\n\n### More information\n\n* <a href=\"https://www.nngroup.com/articles/writing-links/\"\ntarget=\"_resource\">NNG: Writing Hyperlinks: Salient, Descriptive, Start with\nKeyword</a>\n\n* <a href=\"https://www.nomensa.com/blog/2011/writing-good-link-text\"\ntarget=\"_resource\">Nomensa: How to write good link text</a>\n\n* <a href=\"https://accessibility.umn.edu/core-skills/hyperlinks\"\ntarget=\"_resource\">Accessible U: Hyperlinks (Good and Bad Examples)</a>\n"},"gettingStarted":{"menu":"Getting Started","label":"Getting Started","title":"Getting Started with A11yFirst","content":"## Getting Started with A11yFirst\n\n### What is A11yFirst?\n\nBefore you begin using the A11yFirst editor, it is important to know what\nmakes it different from other editors. The name *A11yFirst* hints at some\nof these differences.\n\n*A11y* is shorthand for *accessibility* (*a* + 11 letters + *y*), and\naccessibility in the context of document authoring is about making the\ninformation that documents contain perceivable and understandable by everyone,\nincluding people with disabilities.</p>\n\n### Commitment to accessibility\n\nYour organization, by hosting the A11yFirst editor within its content\nmanagement system, has made a commitment to accessibility because (1) it\nremoves barriers that people with visual, auditory, learning and other\ndisabilities may experience in their use of web information and communication\ntechnologies and (2) it is required by law.\n\nBy following accessibility guidelines when creating public-facing documents,\nyou are fulfilling your role in this commitment.\n\n### Document accessibility\n\nSome of the main components within a document that are important for\naccessibility are:\n\n* **Headings** — These provide titles for the sections and subsections of\ncontent within your document, as well as a title for the document itself.\n\n* **Lists** — By using the list feature, the items in a list are grouped\ntogether and information about the grouping can be conveyed to users of\nassistive technologies.\n\n* **Links** — The text component of a link should describe its target, i.e.,\nthe web site, page or section that will be displayed if you activate the link.\n\n* **Images** — When an image with informational content is included within a\ndocument, a short text description (also known as ‘alt text’) allows screen\nreader users to obtain a concise description of the image.\n\n* **Tables** — By using the table feature to organize tabular data and provide row\nand column headers, users of assistive technologies gain the ability to easily\nnavigate and understand structural relationships within the data.\n\n### A different way of thinking\n\nThe way you think about the process or workflow of creating and editing\ndocuments can make a significant difference in whether the end result, your\nfinished document, is accessible.\n\nFor example, rather than thinking about stylistic considerations such as font\nsizes and colors first, if you make the structure of your document a primary\nconsideration, by breaking it down into sections and subsections and giving\neach of these a meaningful title, you will end up with a document that will\nbe easier for all users to navigate and understand, including people with\ndisabilities.\n"},"aboutA11yFirst":{"menu":"About A11yFirst","label":"About A11yFirst","title":"Description of A11yFirst Project","content":"## About A11yFirst\n\n### Project Description & Goals\n\nThe A11yFirst Project is a collection of modifications to CKEditor, an\nHTML-embedded WYSIWYG editor typically used within content management\nsystems. Its goal is to make the process of creating and editing web documents\none that proactively results in accessible content.\n\nIn the past, authors have had to rely upon remediation tools used at the end\nof the authoring process that ‘fix’ accessibility problems without offering\nmuch guidance on how to prevent them. The A11yFirst editor takes a different\napproach.\n\nFor example, by prompting the author to provide information regarding links\nand images as they are added to the document, accessibility problems are not\nonly avoided, but authors learn on a feature-by-feature basis some of the\nimportant requirements for accessible content.\n\nOther design features in A11yFirst promote the use of blocks such as headings\nand lists that carry with them semantics that are communicated to screen\nreader users and that result in documents that are more easily navigated and\nunderstood by all readers.\n\n### Project Information\n\n* Version: %version\n\n* GitHub Repositories: <a href=\"https://github.com/a11yfirst\"\ntarget=\"_resource\">https://github.com/a11yfirst</a>\n\n### Contributors\n\n* Lucy Chang     (UX, Usability Testing)\n* Jon Gunderson  (Requirements, Development, Usability Testing,\n  Project Management)\n* Nicholas Hoyt  (UX, UI Design, Development, Usability Testing,\n  Project Management)\n* JaEun Jemma Ku (Requirements, Usability Testing, UI Design,\n  Project Management)\n* Eileen Lopez   (UX, Usability Testing)\n* Mark McCarthy  (UX, Usability Testing)\n* Robert Slater  (Requirements)\n* Dena Strong    (UX, Usability Testing)\n\n### Sponsors\n\n* Disability Resources and Educational Services (DRES), College of Applied\n  Health Sciences (AHS), University of Illinois at Urbana-Champaign\n* Illinois Extension, College of Agricultural, Consumer and Environmental\n  Sciences (ACES), University of Illinois at Urbana-Champaign\n* The University Library, Innovation Fund (Jemma Ku, P.I.), University of\n  Illinois at Urbana-Champaign\n* Administrative Information Technology Services (AITS), University of\n  Illinois at Urbana-Champaign\n* School of Information Sciences (iSchool), University of Illinois at\n  Urbana-Champaign\n\n### Acknowledgements\n\nMany of the ideas and motivations for the A11yFirst Project were the result\nof work done previously by a group of software developers at the Illinois\nDepartment of Human Services (DHS), led by Mike Scott, who created the OneNet\ncontent management system, which includes as its centerpiece an accessible\nWYSIWYG editor.\n\nThe OneNet CMS has been in use by the Illinois DHS since 2006 to promote\naccessible authoring for their intranet and main website.\n\nMr. Scott also participated in the requirements gathering phase of the\nA11yFirst Project.\n"}},"codemirror":{"copyright":"Copyright CodeMirror © Marijn Haverbeke. All rights reserved.","dlgTitle":"About CodeMirror Source Plugin","moreInfoShortcuts":"Available Shortcuts","moreInfoShortcuts1":"<strong>CTRL + K</strong> to comment the currently selected text","moreInfoShortcuts2":"<strong>CTRL + SHIFT + K</strong> to uncomment currently selected text","moreInfoShortcuts3":"<strong>CTRL + ALT + K</strong> to auto format currently selected text","moreInfoShortcuts4":"<strong>CTRL + Q</strong> Expand / Collapse Code Block","moreInfoShortcuts5":"<strong>CTRL + F</strong> to perform a search","moreInfoShortcuts6":"<strong>CTRL + G</strong> to find next","moreInfoShortcuts7":"<strong>CTRL + SHIFT + G</strong> to find previous","moreInfoShortcuts8":"<strong>CTRL + SHIFT</strong> to find and replace","moreInfoShortcuts9":"<strong>CTRL + SHIFT + R</strong> to find and replace all","toolbar":"Codi font","searchCode":"Search Source (CTRL + F)","replaceCode":"Replace Code (CTRL + SHIFT + F)","autoFormat":"Format Selection (CTRL + ALT + K)","commentSelectedRange":"Comment Selection (CTRL + K)","uncommentSelectedRange":"Uncomment Selection (CTRL + SHIFT + K)","autoCompleteToggle":"Enable/Disable HTML Tag Autocomplete"},"emoji":{"searchPlaceholder":"Search emoji…","searchLabel":"Input field responsible for searching and filtering emoji inside panel.","navigationLabel":"Groups navigation for emoji sections.","title":"Emoji List","groups":{"people":"People","nature":"Nature and animals","food":"Food and drinks","travel":"Travel and places","activities":"Activities","objects":"Objects","symbols":"Symbols","flags":"Flags"}},"html5video":{"button":"Insereix un vídeo HTML5","title":"Vídeo HTML5","infoLabel":"Informació del vídeo","allowed":"Extensions d'arxius permeses: MP4, WebM, Ogv","urlMissing":"Falta l'URL de la font de vídeo.","videoProperties":"Propietats de vídeo","upload":"Pujar","btnUpload":"Envia-lo al servidor","advanced":"Avançat","autoplay":"Reproducció automàtica?","allowdownload":"Allow download?","advisorytitle":"Advisory title","yes":"Sí","no":"No","loop":"Bucle?","responsive":"Ample adaptatiu","controls":"Mostra els controls","poster":"Miniatura"},"sourcedialog":{"toolbar":"Codi font","title":"Codi font"}};