﻿/*
Copyright (c) 2003-2024, CKSource Holding sp. z o.o. All rights reserved.
For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license/
*/
CKEDITOR.lang['eu']={"application":"Rich Text Editor","editor":"Testu aberastuaren editorea","editorPanel":"Testu aberastuaren editorearen panela","common":{"editorHelp":"Sakatu ALT 0 laguntza jasotzeko","browseServer":"Arakatu zerbitzaria","url":"URLa","protocol":"Protokoloa","upload":"Kargatu","uploadSubmit":"Bidali zerbitzarira","image":"Irudia","form":"Formularioa","checkbox":"Kontrol-laukia","radio":"Aukera-botoia","textField":"Testu-eremua","textarea":"Testu-area","hiddenField":"Ezkutuko eremua","button":"Botoia","select":"Hautespen-eremua","imageButton":"Irudi-botoia","notSet":"<ezarri gabe>","id":"Id","name":"Izena","langDir":"Hizkuntzaren norabidea","langDirLtr":"Ezkerretik eskuinera (LTR)","langDirRtl":"Eskuinetik ezkerrera (RTL)","langCode":"Hizkuntzaren kodea","longDescr":"URLaren deskribapen luzea","cssClass":"Estilo-orriko klaseak","advisoryTitle":"Aholkatutako izenburua","cssStyle":"Estiloa","ok":"Ados","cancel":"Utzi","close":"Itxi","preview":"Aurrebista","resize":"Aldatu tamainaz","generalTab":"Orokorra","advancedTab":"Aurreratua","validateNumberFailed":"Balio hau ez da zenbaki bat.","confirmNewPage":"Eduki honetan gorde gabe dauden aldaketak galduko dira. Ziur zaude orri berri bat kargatu nahi duzula?","confirmCancel":"Aukera batzuk aldatu dituzu. Ziur zaude elkarrizketa-koadroa itxi nahi duzula?","options":"Aukerak","target":"Helburua","targetNew":"Leiho berria (_blank)","targetTop":"Goieneko leihoan (_top)","targetSelf":"Leiho berean (_self)","targetParent":"Leiho gurasoan (_parent)","langDirLTR":"Ezkerretik eskuinera (LTR)","langDirRTL":"Eskuinetik ezkerrera (RTL)","styles":"Estiloa","cssClasses":"Estilo-orriko klaseak","width":"Zabalera","height":"Altuera","align":"Lerrokatzea","left":"Ezkerrean","right":"Eskuinean","center":"Erdian","justify":"Justifikatu","alignLeft":"Lerrokatu ezkerrean","alignRight":"Lerrokatu eskuinean","alignCenter":"Align Center","alignTop":"Goian","alignMiddle":"Erdian","alignBottom":"Behean","alignNone":"Bat ere ez","invalidValue":"Balio desegokia.","invalidHeight":"Altuera zenbaki bat izan behar da.","invalidWidth":"Zabalera zenbaki bat izan behar da.","invalidLength":"Value specified for the \"%1\" field must be a positive number with or without a valid measurement unit (%2).","invalidCssLength":"\"%1\" eremurako zehaztutako balioak zenbaki positibo bat izan behar du, CSS neurri unitate batekin edo gabe (px, %, in, cm, mm, em, ex, pt edo pc).","invalidHtmlLength":"\"%1\" eremurako zehaztutako balioak zenbaki positibo bat izan behar du, HTML neurri unitate batekin edo gabe (px edo %).","invalidInlineStyle":"Lineako estiloan zehaztutako balioak \"izen : balio\" formatuko tupla bat edo gehiago izan behar dira, komaz bereiztuak.","cssLengthTooltip":"Sartu zenbaki bat edo zenbaki bat baliozko CSS unitate batekin (px, %, in, cm, mm, em, ex, pt, edo pc).","unavailable":"%1<span class=\"cke_accessibility\">, erabilezina</span>","keyboard":{"8":"Atzera tekla","13":"Sartu","16":"Maius","17":"Ktrl","18":"Alt","32":"Zuriunea","35":"Buka","36":"Etxea","46":"Ezabatu","112":"F1","113":"F2","114":"F3","115":"F4","116":"F5","117":"F6","118":"F7","119":"F8","120":"F9","121":"F10","122":"F11","123":"F12","124":"F13","125":"F14","126":"F15","127":"F16","128":"F17","129":"F18","130":"F19","131":"F20","132":"F21","133":"F22","134":"F23","135":"F24","224":"Komandoa"},"keyboardShortcut":"Laster-tekla","optionDefault":"Lehenetsia"},"versionCheck":{"notificationMessage":"This CKEditor %current version is not secure. Consider <a target=\"_blank\" href=\"%link\">upgrading to the latest one</a>, %latest.","consoleMessage":"This CKEditor %current version is not secure. Consider upgrading to the latest one, %latest: %link","aboutDialogInsecureMessage":"This CKEditor %current version is not secure.<br>Consider upgrading to the latest one, %latest:<br><a target=\"_blank\" href=\"%link\">%link</a>","aboutDialogUpgradeMessage":"Consider upgrading to the latest editor version, %latest:<br><a target=\"_blank\" href=\"%link\">%link</a>"},"about":{"copy":"Copyright &copy; $1. Eskubide guztiak erreserbaturik.","dlgTitle":"CKEditor 4ri buruz","moreInfo":"Lizentziari buruzko informazioa gure webgunean:"},"basicstyles":{"bold":"Lodia","italic":"Etzana","strike":"Marratua","subscript":"Azpi-indizea","superscript":"Goi-indizea","underline":"Azpimarratu"},"bidi":{"ltr":"Testuaren norantza ezkerretik eskuinera","rtl":"Testuaren norantza eskuinetik ezkerrera"},"blockquote":{"toolbar":"Aipamen blokea"},"notification":{"closed":"Jakinarazpena itxita."},"toolbar":{"toolbarCollapse":"Tolestu tresna-barra","toolbarExpand":"Zabaldu tresna-barra","toolbarGroups":{"document":"Dokumentua","clipboard":"Arbela/Desegin","editing":"Editatu","forms":"Formularioak","basicstyles":"Oinarrizko estiloak","paragraph":"Paragrafoa","links":"Estekak","insert":"Txertatu","styles":"Estiloak","colors":"Koloreak","tools":"Tresnak"},"toolbars":"Editorearen tresna-barrak"},"clipboard":{"copy":"Kopiatu","copyError":"Zure web nabigatzailearen segurtasun ezarpenek ez dute baimentzen testuak automatikoki kopiatzea. Mesedez teklatua erabil ezazu (Ctrl/Cmd+C).","cut":"Ebaki","cutError":"Zure web nabigatzailearen segurtasun ezarpenek ez dute baimentzen testuak automatikoki moztea. Mesedez teklatua erabil ezazu (Ctrl/Cmd+X).","paste":"Itsatsi","pasteNotification":"Press %1 to paste. Your browser doesn‘t support pasting with the toolbar button or context menu option.","pasteArea":"Itsasteko area","pasteMsg":"Paste your content inside the area below and press OK.","fileFormatNotSupportedNotification":"The ${formats} file format(s) are not supported.","fileWithoutFormatNotSupportedNotification":"The file format is not supported."},"colorbutton":{"auto":"Automatikoa","bgColorTitle":"Atzeko planoko kolorea","colors":{"000":"Beltza","800000":"Granatea","8B4513":"Zela marroia","2F4F4F":"Arbel gris iluna","008080":"Urdin berdexka","000080":"Urdin iluna","4B0082":"Indigoa","696969":"Gris iluna","B22222":"Adreilu erregogorra","A52A2A":"Marroia","DAA520":"Urrezko makila","006400":"Berde iluna","40E0D0":"Turkesa","0000CD":"Urdin ertaina","800080":"Morea","808080":"Grisa","F00":"Gorria","FF8C00":"Laranja iluna","FFD700":"Urrea","008000":"Berdea","0FF":"Ziana","00F":"Urdina","EE82EE":"Bioleta","A9A9A9":"Gris ahula","FFA07A":"Izokin-kolore argia","FFA500":"Laranja","FFFF00":"Horia","00FF00":"Lima","AFEEEE":"Turkesa argia","ADD8E6":"Urdin argia","DDA0DD":"Aran-kolorea","D3D3D3":"Gris argia","FFF0F5":"Izpiliku-gorrixka","FAEBD7":"Zuri zaharra","FFFFE0":"Hori argia","F0FFF0":"Ezti-ihintza","F0FFFF":"Zeru-urdina","F0F8FF":"Alizia urdina","E6E6FA":"Izpilikua","FFF":"Zuria","1ABC9C":"Strong Cyan","2ECC71":"Emerald","3498DB":"Bright Blue","9B59B6":"Amethyst","4E5F70":"Grayish Blue","F1C40F":"Vivid Yellow","16A085":"Dark Cyan","27AE60":"Dark Emerald","2980B9":"Strong Blue","8E44AD":"Dark Violet","2C3E50":"Desaturated Blue","F39C12":"Orange","E67E22":"Carrot","E74C3C":"Pale Red","ECF0F1":"Bright Silver","95A5A6":"Light Grayish Cyan","DDD":"Light Gray","D35400":"Pumpkin","C0392B":"Strong Red","BDC3C7":"Silver","7F8C8D":"Grayish Cyan","999":"Gris iluna"},"more":"Kolore gehiago...","panelTitle":"Koloreak","textColorTitle":"Testu-kolorea"},"colordialog":{"clear":"Garbitu","highlight":"Nabarmendu","options":"Kolore aukerak","selected":"Hautatutako kolorea","title":"Hautatu kolorea"},"templates":{"button":"Txantiloiak","emptyListMsg":"(Ez dago txantiloirik definituta)","insertOption":"Ordeztu uneko edukiak","options":"Txantiloi aukerak","selectPromptMsg":"Mesedez hautatu txantiloia editorean irekitzeko","title":"Eduki txantiloiak"},"contextmenu":{"options":"Testuinguru-menuaren aukerak"},"copyformatting":{"label":"Kopiatu formatua","notification":{"copied":"Formatua kopiatuta","applied":"Formatua aplikatuta","canceled":"Formatua bertan behera utzita","failed":"Formatuak huts egin du. Ezin dituzu estiloak kopiatu gabe aplikatu."}},"div":{"IdInputLabel":"Id","advisoryTitleInputLabel":"Aholkatutako izenburua","cssClassInputLabel":"Estilo-orriko klaseak","edit":"Editatu Div-a","inlineStyleInputLabel":"Lineako estiloa","langDirLTRLabel":"Ezkerretik eskuinera (LTR)","langDirLabel":"Hizkuntzaren norabidea","langDirRTLLabel":"Eskuinetik ezkerrera (RTL)","languageCodeInputLabel":"Hizkuntzaren kodea","remove":"Kendu Div-a","styleSelectLabel":"Estiloa","title":"Sortu Div edukiontzia","toolbar":"Sortu Div edukiontzia"},"elementspath":{"eleLabel":"Elementuen bidea","eleTitle":"%1 elementua"},"exportpdf":{"documentReady":"Document is ready!","error":"Error occurred.","processingDocument":"Processing PDF document...","toolbar":"Export to PDF"},"filetools":{"loadError":"Errorea gertatu da fitxategia irakurtzean.","networkError":"Sareko errorea gertatu da fitxategia kargatzean.","httpError404":"HTTP errorea gertatu da fitxategia kargatzean (404: Fitxategia ez da aurkitu).","httpError403":"HTTP errorea gertatu da fitxategia kargatzean (403: Debekatuta).","httpError":"HTTP errorea gertatu da fitxategia kargatzean (errore-egoera: %1).","noUrlError":"Kargatzeko URLa definitu gabe.","responseError":"Zerbitzariaren erantzun okerra."},"find":{"find":"Bilatu","findOptions":"Bilaketaren aukerak","findWhat":"Bilatu hau:","matchCase":"Maiuskula/minuskula","matchCyclic":"Bilaketa ziklikoa","matchWord":"Bilatu hitz osoa","notFoundMsg":"Ez da aurkitu zehazturiko testua.","replace":"Ordezkatu","replaceAll":"Ordezkatu guztiak","replaceSuccessMsg":"%1 aldiz ordezkatua.","replaceWith":"Ordezkatu honekin:","title":"Bilatu eta ordezkatu"},"font":{"fontSize":{"label":"Tamaina","voiceLabel":"Letra-tamaina","panelTitle":"Letra-tamaina"},"label":"Letra-tipoa","panelTitle":"Letra-tipoaren izena","voiceLabel":"Letra-tipoa"},"fakeobjects":{"anchor":"Aingura","hiddenfield":"Ezkutuko eremua","iframe":"IFrame-a","unknown":"Objektu ezezaguna"},"forms":{"button":{"title":"Botoiaren ezaugarriak","text":"Testua (balioa)","type":"Mota","typeBtn":"Botoia","typeSbm":"Bidali","typeRst":"Berrezarri"},"checkboxAndRadio":{"checkboxTitle":"Kontrol-laukiaren propietateak","radioTitle":"Aukera-botoiaren propietateak","value":"Balioa","selected":"Hautatuta","required":"Beharrezkoa"},"form":{"title":"Formularioaren propietateak","menu":"Formularioaren propietateak","action":"Ekintza","method":"Metodoa","encoding":"Kodeketa"},"hidden":{"title":"Ezkutuko eremuaren propietateak","name":"Izena","value":"Balioa"},"select":{"title":"Hautespen eremuaren propietateak","selectInfo":"Hautatu informazioa","opAvail":"Erabilgarri dauden aukerak","value":"Balioa","size":"Tamaina","lines":"lerro kopurua","chkMulti":"baimendu hautapen anitzak","required":"Beharrezkoa","opText":"Testua","opValue":"Balioa","btnAdd":"Gehitu","btnModify":"Aldatu","btnUp":"Gora","btnDown":"Behera","btnSetValue":"Ezarri hautatutako balio bezala","btnDelete":"Ezabatu"},"textarea":{"title":"Testu-arearen propietateak","cols":"Zutabeak","rows":"Errenkadak"},"textfield":{"title":"Testu-eremuaren propietateak","name":"Izena","value":"Balioa","charWidth":"Karaktere-zabalera","maxChars":"Gehienezko karaktereak","required":"Beharrezkoa","type":"Mota","typeText":"Testua","typePass":"Pasahitza","typeEmail":"E-posta","typeSearch":"Bilatu","typeTel":"Telefono zenbakia","typeUrl":"URLa"}},"format":{"label":"Formatua","panelTitle":"Paragrafoaren formatua","tag_address":"Helbidea","tag_div":"Normala (DIV)","tag_h1":"Izenburua 1","tag_h2":"Izenburua 2","tag_h3":"Izenburua 3","tag_h4":"Izenburua 4","tag_h5":"Izenburua 5","tag_h6":"Izenburua 6","tag_p":"Normala","tag_pre":"Formatuduna"},"horizontalrule":{"toolbar":"Txertatu marra horizontala"},"iframe":{"border":"Erakutsi markoaren ertza","noUrl":"Idatzi iframe-aren URLa, mesedez.","scrolling":"Gaitu korritze-barrak","title":"IFrame-aren propietateak","toolbar":"IFrame-a","tabindex":"Remove from tabindex"},"image":{"alt":"Ordezko testua","border":"Ertza","btnUpload":"Bidali zerbitzarira","button2Img":"Hautatutako irudi-botoia irudi arrunt bihurtu nahi duzu?","hSpace":"HSpace","img2Button":"Hautatutako irudia irudi-botoi bihurtu nahi duzu?","infoTab":"Irudiaren informazioa","linkTab":"Esteka","lockRatio":"Blokeatu erlazioa","menu":"Irudiaren propietateak","resetSize":"Berrezarri tamaina","title":"Irudiaren propietateak","titleButton":"Irudi-botoiaren propietateak","upload":"Kargatu","urlMissing":"Irudiaren iturburuaren URLa falta da.","vSpace":"VSpace","validateBorder":"Ertza zenbaki oso bat izan behar da.","validateHSpace":"HSpace zenbaki oso bat izan behar da.","validateVSpace":"VSpace zenbaki oso bat izan behar da."},"indent":{"indent":"Handitu koska","outdent":"Txikitu koska"},"smiley":{"options":"Aurpegieren aukerak","title":"Txertatu aurpegiera","toolbar":"Aurpegierak"},"language":{"button":"Ezarri hizkuntza","remove":"Kendu hizkuntza"},"link":{"acccessKey":"Sarbide-tekla","advanced":"Aurreratua","advisoryContentType":"Aholkatutako eduki-mota","advisoryTitle":"Aholkatutako izenburua","anchor":{"toolbar":"Aingura","menu":"Editatu aingura","title":"Ainguraren propietateak","name":"Ainguraren izena","errorName":"Idatzi ainguraren izena","errorWhitespace":"Anchor name cannot contain space characters","remove":"Kendu aingura"},"anchorId":"Elementuaren Id-aren arabera","anchorName":"Aingura-izenaren arabera","charset":"Estekatutako baliabide karaktere-jokoa","cssClasses":"Estilo-orriko klaseak","download":"Behartu deskarga","displayText":"Bistaratu testua","emailAddress":"E-posta helbidea","emailBody":"Mezuaren gorputza","emailSubject":"Mezuaren gaia","id":"Id","info":"Estekaren informazioa","langCode":"Hizkuntzaren kodea","langDir":"Hizkuntzaren norabidea","langDirLTR":"Ezkerretik eskuinera (LTR)","langDirRTL":"Eskuinetik ezkerrera (RTL)","menu":"Editatu esteka","name":"Izena","noAnchors":"(Ez dago aingurarik erabilgarri dokumentuan)","noEmail":"Mesedez idatzi e-posta helbidea","noUrl":"Mesedez idatzi estekaren URLa","noTel":"Please type the phone number","other":"<bestelakoa>","phoneNumber":"Phone number","popupDependent":"Menpekoa (Netscape)","popupFeatures":"Laster-leihoaren ezaugarriak","popupFullScreen":"Pantaila osoa (IE)","popupLeft":"Ezkerreko posizioa","popupLocationBar":"Kokaleku-barra","popupMenuBar":"Menu-barra","popupResizable":"Tamaina aldakorra","popupScrollBars":"Korritze-barrak","popupStatusBar":"Egoera-barra","popupToolbar":"Tresna-barra","popupTop":"Goiko posizioa","rel":"Erlazioa","selectAnchor":"Hautatu aingura","styles":"Estiloa","tabIndex":"Tabulazio indizea","target":"Helburua","targetFrame":"<frame>","targetFrameName":"Helburuko markoaren izena","targetPopup":"<laster-leihoa>","targetPopupName":"Laster-leihoaren izena","title":"Esteka","toAnchor":"Estekatu testuko aingurara","toEmail":"E-posta","toUrl":"URLa","toPhone":"Phone","toolbar":"Esteka","type":"Esteka-mota","unlink":"Kendu esteka","upload":"Kargatu"},"list":{"bulletedlist":"Buletdun Zerrenda","numberedlist":"Zenbakidun Zerrenda"},"liststyle":{"bulletedTitle":"Buletadun zerrendaren propietateak","circle":"Zirkulua","decimal":"Hamartarra (1, 2, 3...)","disc":"Diskoa","lowerAlpha":"Alfabetoa minuskulaz (a, b, c, d, e...)","lowerRoman":"Erromatarra minuskulaz (i, ii, iii, iv, v...)","none":"Bat ere ez","notset":"<ezarri gabea>","numberedTitle":"Zenbakidun zerrendaren propietateak","square":"Karratua","start":"Hasi","type":"Mota","upperAlpha":"Alfabetoa maiuskulaz (A, B, C, D, E...)","upperRoman":"Erromatarra maiuskulaz (I, II, III, IV, V, etc.)","validateStartNumber":"Zerrendaren hasierako zenbakiak zenbaki osoa izan behar du."},"magicline":{"title":"Txertatu paragrafoa hemen"},"maximize":{"maximize":"Maximizatu","minimize":"Minimizatu"},"newpage":{"toolbar":"Orrialde berria"},"pagebreak":{"alt":"Orrialde-jauzia","toolbar":"Txertatu orrialde-jauzia inprimatzean"},"pastetext":{"button":"Itsatsi testu arrunta bezala","pasteNotification":"Press %1 to paste. Your browser doesn‘t support pasting with the toolbar button or context menu option.","title":"Itsatsi testu arrunta bezala"},"pastefromword":{"confirmCleanup":"Itsatsi nahi duzun testua Word-etik kopiatua dela dirudi. Itsatsi baino lehen garbitu nahi duzu?","error":"Barne-errore bat dela eta ezin izan da itsatsitako testua garbitu","title":"Itsatsi Word-etik","toolbar":"Itsatsi Word-etik"},"preview":{"preview":"Aurrebista"},"print":{"toolbar":"Inprimatu"},"removeformat":{"toolbar":"Kendu formatua"},"save":{"toolbar":"Gorde"},"selectall":{"toolbar":"Hautatu dena"},"showblocks":{"toolbar":"Erakutsi blokeak"},"sourcearea":{"toolbar":"Iturburua"},"specialchar":{"options":"Karaktere berezien aukerak","title":"Hautatu karaktere berezia","toolbar":"Txertatu karaktere berezia"},"scayt":{"btn_about":"SCAYTi buruz","btn_dictionaries":"Hiztegiak","btn_disable":"Desgaitu SCAYT","btn_enable":"Gaitu SCAYT","btn_langs":"Hizkuntzak","btn_options":"Aukerak","text_title":"Ortografia Zuzenketa Idatzi Ahala (SCAYT)"},"stylescombo":{"label":"Estiloak","panelTitle":"Formatu estiloak","panelTitle1":"Bloke estiloak","panelTitle2":"Lineako estiloak","panelTitle3":"Objektu estiloak"},"table":{"border":"Ertzaren zabalera","caption":"Epigrafea","cell":{"menu":"Gelaxka","insertBefore":"Txertatu gelaxka aurretik","insertAfter":"Txertatu gelaxka ondoren","deleteCell":"Ezabatu gelaxkak","merge":"Batu gelaxkak","mergeRight":"Batu eskuinetara","mergeDown":"Batu behera","splitHorizontal":"Banatu gelaxka horizontalki","splitVertical":"Banatu gelaxka bertikalki","title":"Gelaxkaren propietateak","cellType":"Gelaxka-mota","rowSpan":"Errenkaden hedadura","colSpan":"Zutabeen hedadura","wordWrap":"Itzulbira","hAlign":"Lerrokatze horizontala","vAlign":"Lerrokatze bertikala","alignBaseline":"Oinarri-lerroan","bgColor":"Atzeko planoaren kolorea","borderColor":"Ertzaren kolorea","data":"Data","header":"Goiburua","columnHeader":"Column Header","rowHeader":"Row Header","yes":"Bai","no":"Ez","invalidWidth":"Gelaxkaren zabalera zenbaki bat izan behar da.","invalidHeight":"Gelaxkaren altuera zenbaki bat izan behar da.","invalidRowSpan":"Errenkaden hedadura zenbaki osoa izan behar da.","invalidColSpan":"Zutabeen hedadura zenbaki osoa izan behar da.","chooseColor":"Aukeratu"},"cellPad":"Gelaxken betegarria","cellSpace":"Gelaxka arteko tartea","column":{"menu":"Zutabea","insertBefore":"Txertatu zutabea aurretik","insertAfter":"Txertatu zutabea ondoren","deleteColumn":"Ezabatu zutabeak"},"columns":"Zutabeak","deleteTable":"Ezabatu taula","headers":"Goiburuak","headersBoth":"Biak","headersColumn":"Lehen zutabea","headersNone":"Bat ere ez","headersRow":"Lehen errenkada","heightUnit":"height unit","invalidBorder":"Ertzaren tamaina zenbaki bat izan behar da.","invalidCellPadding":"Gelaxken betegarria zenbaki bat izan behar da.","invalidCellSpacing":"Gelaxka arteko tartea zenbaki bat izan behar da.","invalidCols":"Zutabe kopurua 0 baino handiagoa den zenbakia izan behar da.","invalidHeight":"Taularen altuera zenbaki bat izan behar da.","invalidRows":"Errenkada kopurua 0 baino handiagoa den zenbakia izan behar da.","invalidWidth":"Taularen zabalera zenbaki bat izan behar da.","menu":"Taularen propietateak","row":{"menu":"Errenkada","insertBefore":"Txertatu errenkada aurretik","insertAfter":"Txertatu errenkada ondoren","deleteRow":"Ezabatu errenkadak"},"rows":"Errenkadak","summary":"Laburpena","title":"Taularen propietateak","toolbar":"Taula","widthPc":"ehuneko","widthPx":"pixel","widthUnit":"zabalera unitatea"},"undo":{"redo":"Berregin","undo":"Desegin"},"widget":{"move":"Klikatu eta arrastatu lekuz aldatzeko","label":"%1 widget"},"uploadwidget":{"abort":"Karga erabiltzaileak bertan behera utzita.","doneOne":"Fitxategia behar bezala kargatu da.","doneMany":"Behar bezala kargatu dira %1 fitxategi.","uploadOne":"Fitxategia kargatzen ({percentage}%)...","uploadMany":"Fitxategiak kargatzen, {current} / {max} eginda ({percentage}%)..."},"a11yfirsthelp":{"label":"A11yFirst Help","panelTitle":"Learn about A11yFirst features","keyboardShortcutsLabel":"Keyboard Shortcuts","versionLabel":"Version","a11yFirstHelpLabel":"A11yFirst Help: Content Accessibility","a11yFirstHelpTitle":"Information to help authors understand how the A11yFirst features help them make content more accessible to people with disabilites","headingHelp":{"menu":"Heading / Paragraph","label":"Heading / Paragraph","title":"Heading / Paragraph Help","content":"## Heading / Paragraph\n\n### Menu items\n* **H1 – Document title** — Typically should be the first heading in the\n  document and used only once.\n* **H2 – Section title** — Describes a main or top-level section in the\n  document.\n* **H3 to H6 – Subsection title** — Describes a subsection within a top-level\n  section or other subsection of the document.\n* **Normal** — The default paragraph format, typically with significant top\n  and bottom margins.\n* **Preformatted text** — Use this for computer code blocks to maintain spacing\n  and indentation.\n* **Address line** — Use this to type a series of address lines styled in\n  italics and with minimal top and bottom margins. When you press enter at the\n  end of a line, the next line is also an address line.\n\n### About headings\n* The Heading / Paragraph menu only enables the **allowed** heading levels.\n\n* The cursor position relative to other headings in the document determines\nwhich heading levels are allowed.\n\n### About paragraph formats\n* Visual styling for paragraph formats is predetermined by your organization,\nthus freeing up your time and energy for concentrating on the structure and\nmeaning of the content within your document.\n\n### Why headings and paragraph formats are important\n* The purpose of a heading is to label the content that follows it.\n\n* The proper nesting of heading levels improves the ability of all users to\nfind and comprehend information on a page.\n\n* Headings used consistently and in meaningful ways improve Search Engine\nOptimization (SEO).\n\n* Properly nested headings enable people using assistive technologies to easily\nnavigate to each section of a document.\n\n* When paragraph formats are used properly (e.g. *Preformatted* or *Address*),\nthey help users of assistive technologies understand the intended role of the\ncontent.\n\n* Thinking in terms of blocks such as headings and paragraph formats within\nyour document is a higher-level approach to providing structure and semantics\nthat are important for all users.\n\n### More information\n* Documents are easier to read and understand when headings identify the topics\nthey contain.\n\n* Headings make it easier to scan and find topics of interest within a document.\n\n* Heading levels identify the structural relationships between sections of\ncontent in a document.\n\n* Higher-level headings (Levels 1 and 2) identify the main topics of a document\nand lower-level headings (Levels 3, 4, 5 and 6) identify subsections of the\ndocument.\n\n* A subsection is identified by using the next lower-level heading. For\nexample, subsections of Level 2 headings use Level 3 headings, subsections of\nLevel 3 headings use Level 4 headings, and so on to Level 6 headings.\n\n* Break content into subsections when there are two or more ideas or concepts\nthat correspond to the topics covered in the section. Use headings of the same\nlevel to label each subsection.\n\n* Heading levels should **never** be used for inline visual styling of content\n(e.g. larger or smaller font size, bold or italic). Instead, use the `Inline\nStyle` options.\n"},"listHelp":{"menu":"List","label":"List","title":"List Help","content":"## List\n\n### Working with lists\n\n<img style=\"padding: 8px 0 3px 5px\" alt=\"list toolbar buttons\"\nsrc=\"basePath/plugins/a11yfirsthelp/images/list-buttons.png\"/>\n\nUse the toolbar buttons shown above to:\n\n* Insert/Remove Numbered List\n* Insert/Remove Bulleted List\n* Increase Indent\n* Decrease Indent\n\n### List properties via context menu\n\nThe context menu allows further configuration of list properties such as\nnumbering and bullet types by selecting:\n\n* Numbered List Properties\n* Bulleted List Properties\n\nThe context menu can be invoked by positioning the cursor in a list item and:\n\n* right-clicking, using the mouse, or\n* using Mouse Keys on Windows or Mac.\n\n### About lists\n\n* Use a numbered list when the order or sequence of the items is significant.\n* Use a bulleted list when the order of the items is not significant.\n\n### Why lists are important\n\n* Lists convey grouping semantics for related items.\n* Lists may also convey hierarchical structure.\n* When related items are grouped as a list, information about the list is\n  conveyed to screen reader users, including the type of list, the number of\n  items it contains and the sequence number of the current list item.\n"},"imageHelp":{"menu":"Image","label":"Image","title":"Image Help","content":"## Image\n\n### Accessible image descriptions\n\n* People with visual impairments or visual processing disorders need\n  accessible text descriptions of informative images.\n\n* There are two types of accessible descriptions for images: *alternative\n  text* and *long descriptions*.\n\n### Alternative text\n\n* Succinctly describes the content and function of the image for people\n  with visual impairments, in no more than 100 characters\n\n* Is required for informative images (but not for images that are purely\n  decorative)\n\n* Is not visible in the document; it is communicated to screen reader users\n  via the *img* element's *alt* attribute\n\n* For a purely decorative image, select the **‘Image does not require\n  alternative text’** checkbox and leave the alternative text field blank.\n\n### Long descriptions for complex images\n\n* A complex image has informational content that cannot be described adequately\n  by alternative text of 100 characters or less.\n\n* Examples of complex images include charts, graphs, diagrams, scientific\n  photographs and works of art.\n\n* A complex image needs both a concise alternative text description and a\n  longer, more detailed description.\n\n* Accessibility requirements mandate that the long description of a complex\n  image be placed in the document adjacent to the image.\n\n### Adding a long description in the document\n\nFollow these steps when adding a long description of a complex image:\n\n1. Add an adequately detailed description of the image within the document,\n   either just before or after the image (or both).\n\n1. In answer to the question **‘Is a long description needed, and if so,\n   where will it be located’**, select one of the following:\n       * Yes; in the document before the image\n       * Yes; in the document after the image\n       * Yes; in the document before and after the image\n\nBy specifying the location of the long description relative to the image,\nscreen reader users will be informed of its existence and location in the\ndocument. (This information is appended to the alternative text.)\n\n### Insert a caption text box below the image\n\n* A **caption** is an optional visual label supported by CKEditor for an image.\n  It provides an additional way to describe an image that is immediately below\n  and proximate to the image.\n\n* The caption content is specified and is editable in the text box just below\n  the image, once it has been inserted in the document.\n\n* From an accessibility perspective the *caption* and the *alternative text*\n  should not be the same, but instead should complement each other.\n\n* Using the caption creates a *figcaption* element contained in a *figure*\n  element. The *figure* element also contains the *img* element.\n\n### Writing effective alternative text\n\nThe following are based on <a href=\"https://webaim.org\" target=\"_resource\">\nWebAIM</a>'s guidelines for alternative text:\n\n* **Be accurate and equivalent** in presenting the same *content* and\n  *function* of the image.\n\n* When **images are used as links**, the alternative text should describe the\n  target of the link.\n\n* **Be succinct.** This means the correct content and function of the image\n  should be presented as succinctly as is appropriate. Typically no more than\n  a few words are necessary, though rarely a short sentence or two may be\n  appropriate. The length should not exceed 100 characters.\n\n* **Do NOT be redundant** or provide the same information as text that is\n  already part of the document.\n\n* **Do NOT use the phrases “image of ...” or “graphic of ...”** to describe\n  the image. Assistive technologies notify the user of the image.  It is your\n  job to describe the purpose or the content of the image.  If the image is a\n  photograph or illustration, etc. of important content, it may be useful to\n  include this in the alternative text.\n\n* **Do NOT include file names or sizes** as part of the alternative text.\n\n### Why image descriptions are important\n\nAdding text descriptions of images is an important part of making documents\naccessible to the visually impaired who use assistive devices such as screen\nreaders and magnifiers, and to people with visual processing disorders, which\nmake especially complex images more difficult to understand.\n\nWhen the user cannot see all or part of an image, assistive technologies will\nread or display its alternative text description. This is especially important\nwhen the image conveys information that is required for the user to fully\nunderstand the information in the document.\n\nFor people with visual processing disorders, a detailed description of a\ncomplex image helps them to more quickly or completely understand the\ninformation being conveyed by the image.\n\n### More information\n\n* <a href=\"https://accessibility.psu.edu/images/alttext/\"\ntarget=\"_resource\">Penn State: Image ALT Text</a>\n\n* <a href=\"https://webaim.org/techniques/alttext/\"\ntarget=\"_resource\">WebAIM: Alternative Text</a>\n\n* <a href=\"https://www.w3.org/WAI/tutorials/images/\"\ntarget=\"_resource\">W3C Web Accessibility Image Tutorial</a>\n\n* <a href=\"http://diagramcenter.org/\" target=\"_resource\">Diagram Center</a>\n"},"inlineStyleHelp":{"menu":"Character Style","label":"Character Style","title":"Character Style Help","content":"## Character Style\n\n### Working with character styles\n\n* To apply a character style to existing text, select a range of text and then\nchoose an option from the menu.\n\n* To apply a character style to text you are about to type, choose an option\nfrom the menu and begin typing. The style will continue to be applied until\nyou choose another option or move the cursor to a different point in the\ndocument.\n\n* Multiple character styles can be applied to selected text.\n\n### About character styles\n\n* Character styles have a different purpose than paragraph formats. They are\nused at a lower level to highlight words or phrases within blocks of text.\n\n* Character styles, when used properly, help screen reader users better\nunderstand the types and meanings of lower-level stylistic changes within\nblocks of text.\n\n### Character styles vs. headings, lists and paragraph formats\n\n* Thinking in terms of headings, lists and paragraph formats first, and then\nusing character styles to emphasize key words or phrases within text blocks,\nresults in documents that are easier to read and understand.\n\n* When headings, lists and paragraph formats are considered as primary, and\ncharacter styles secondary, many visual styling decisions can be avoided, as\nthey are already made by default.\n\n* When character styles are used to change the styling of blocks of text\nwithout regard to whether the block is a heading, list item or other type of\nparagraph format, it makes the document more difficult to read and understand\nwithin the context of the website.\n\n* Using headings, lists, paragraph formats and character styles properly will\nmake it easier for you to maintain stylistic consistency.\n"},"linkHelp":{"menu":"Link","label":"Link","title":"Link Help","content":"## Link\n\n### Display Text\n\nProviding accessible *Display Text* is straightforward if you keep the\nfollowing guidelines in mind:\n\n1. The *Display Text* for a link should describe the target of the link.\n\n1. Do not use ambiguous text, such as “Click Here” or “More”.\n\n1. Do not begin the *Display Text* with redundant words or phrases such as\n   “Link” or “Link to”.\n\n1. Be consistent: Links to the same URL or e-mail address should have the same\n   *Display Text*.\n\n1. In most cases, it is best not to use the link URL or e-mail address as the\n   *Display Text*.\n\n### About links\n\n* Screen reader users often use the “List of Links” feature to identify and\n  navigate to links on a page. When links are presented as a list,  using\n  descriptive *Display Text* becomes even more important since understanding\n  the target of each link no longer benefits from its original context within\n  the document.\n\n* Screen reader users often use the “Search” feature to find links on a page\n  based on keywords they would expect to find in the *Display Text* of the\n  links. Thus the more descriptive the link *Display Text*, the more effective\n  the search feature will be in finding relevant links.\n\n* Usable and accessible *Display Text* should be descriptive, unique and start\n  with keywords (NNG).\n\n* The *Display Text* for links is like a sign post. It should tell you what\n  you’ll find when you follow it (NOMENSA).\n\n### Why links are important\n\n* Descriptive link text makes it easier for everyone to find and follow links\n  on a page that are of interest to them.\n\n* Descriptive link text is especially important for people using screen\n  readers, who typically only hear the display text spoken to them through\n  speech synthesis and do not \"see\" the link in the context of other content\n  on the page.\n\n* When URLs, e-mail addresses or other ambiguous text are used as the display\n  text for a link, it is impossible in many cases, and much more difficult in\n  the remaining cases, for screen reader users to find and follow links of\n  interest to them.\n\n### More information\n\n* <a href=\"https://www.nngroup.com/articles/writing-links/\"\ntarget=\"_resource\">NNG: Writing Hyperlinks: Salient, Descriptive, Start with\nKeyword</a>\n\n* <a href=\"https://www.nomensa.com/blog/2011/writing-good-link-text\"\ntarget=\"_resource\">Nomensa: How to write good link text</a>\n\n* <a href=\"https://accessibility.umn.edu/core-skills/hyperlinks\"\ntarget=\"_resource\">Accessible U: Hyperlinks (Good and Bad Examples)</a>\n"},"gettingStarted":{"menu":"Getting Started","label":"Getting Started","title":"Getting Started with A11yFirst","content":"## Getting Started with A11yFirst\n\n### What is A11yFirst?\n\nBefore you begin using the A11yFirst editor, it is important to know what\nmakes it different from other editors. The name *A11yFirst* hints at some\nof these differences.\n\n*A11y* is shorthand for *accessibility* (*a* + 11 letters + *y*), and\naccessibility in the context of document authoring is about making the\ninformation that documents contain perceivable and understandable by everyone,\nincluding people with disabilities.</p>\n\n### Commitment to accessibility\n\nYour organization, by hosting the A11yFirst editor within its content\nmanagement system, has made a commitment to accessibility because (1) it\nremoves barriers that people with visual, auditory, learning and other\ndisabilities may experience in their use of web information and communication\ntechnologies and (2) it is required by law.\n\nBy following accessibility guidelines when creating public-facing documents,\nyou are fulfilling your role in this commitment.\n\n### Document accessibility\n\nSome of the main components within a document that are important for\naccessibility are:\n\n* **Headings** — These provide titles for the sections and subsections of\ncontent within your document, as well as a title for the document itself.\n\n* **Lists** — By using the list feature, the items in a list are grouped\ntogether and information about the grouping can be conveyed to users of\nassistive technologies.\n\n* **Links** — The text component of a link should describe its target, i.e.,\nthe web site, page or section that will be displayed if you activate the link.\n\n* **Images** — When an image with informational content is included within a\ndocument, a short text description (also known as ‘alt text’) allows screen\nreader users to obtain a concise description of the image.\n\n* **Tables** — By using the table feature to organize tabular data and provide row\nand column headers, users of assistive technologies gain the ability to easily\nnavigate and understand structural relationships within the data.\n\n### A different way of thinking\n\nThe way you think about the process or workflow of creating and editing\ndocuments can make a significant difference in whether the end result, your\nfinished document, is accessible.\n\nFor example, rather than thinking about stylistic considerations such as font\nsizes and colors first, if you make the structure of your document a primary\nconsideration, by breaking it down into sections and subsections and giving\neach of these a meaningful title, you will end up with a document that will\nbe easier for all users to navigate and understand, including people with\ndisabilities.\n"},"aboutA11yFirst":{"menu":"About A11yFirst","label":"About A11yFirst","title":"Description of A11yFirst Project","content":"## About A11yFirst\n\n### Project Description & Goals\n\nThe A11yFirst Project is a collection of modifications to CKEditor, an\nHTML-embedded WYSIWYG editor typically used within content management\nsystems. Its goal is to make the process of creating and editing web documents\none that proactively results in accessible content.\n\nIn the past, authors have had to rely upon remediation tools used at the end\nof the authoring process that ‘fix’ accessibility problems without offering\nmuch guidance on how to prevent them. The A11yFirst editor takes a different\napproach.\n\nFor example, by prompting the author to provide information regarding links\nand images as they are added to the document, accessibility problems are not\nonly avoided, but authors learn on a feature-by-feature basis some of the\nimportant requirements for accessible content.\n\nOther design features in A11yFirst promote the use of blocks such as headings\nand lists that carry with them semantics that are communicated to screen\nreader users and that result in documents that are more easily navigated and\nunderstood by all readers.\n\n### Project Information\n\n* Version: %version\n\n* GitHub Repositories: <a href=\"https://github.com/a11yfirst\"\ntarget=\"_resource\">https://github.com/a11yfirst</a>\n\n### Contributors\n\n* Lucy Chang     (UX, Usability Testing)\n* Jon Gunderson  (Requirements, Development, Usability Testing,\n  Project Management)\n* Nicholas Hoyt  (UX, UI Design, Development, Usability Testing,\n  Project Management)\n* JaEun Jemma Ku (Requirements, Usability Testing, UI Design,\n  Project Management)\n* Eileen Lopez   (UX, Usability Testing)\n* Mark McCarthy  (UX, Usability Testing)\n* Robert Slater  (Requirements)\n* Dena Strong    (UX, Usability Testing)\n\n### Sponsors\n\n* Disability Resources and Educational Services (DRES), College of Applied\n  Health Sciences (AHS), University of Illinois at Urbana-Champaign\n* Illinois Extension, College of Agricultural, Consumer and Environmental\n  Sciences (ACES), University of Illinois at Urbana-Champaign\n* The University Library, Innovation Fund (Jemma Ku, P.I.), University of\n  Illinois at Urbana-Champaign\n* Administrative Information Technology Services (AITS), University of\n  Illinois at Urbana-Champaign\n* School of Information Sciences (iSchool), University of Illinois at\n  Urbana-Champaign\n\n### Acknowledgements\n\nMany of the ideas and motivations for the A11yFirst Project were the result\nof work done previously by a group of software developers at the Illinois\nDepartment of Human Services (DHS), led by Mike Scott, who created the OneNet\ncontent management system, which includes as its centerpiece an accessible\nWYSIWYG editor.\n\nThe OneNet CMS has been in use by the Illinois DHS since 2006 to promote\naccessible authoring for their intranet and main website.\n\nMr. Scott also participated in the requirements gathering phase of the\nA11yFirst Project.\n"}},"codemirror":{"copyright":"Copyright CodeMirror © Marijn Haverbeke. All rights reserved.","dlgTitle":"About CodeMirror Source Plugin","moreInfoShortcuts":"Available Shortcuts","moreInfoShortcuts1":"<strong>CTRL + K</strong> to comment the currently selected text","moreInfoShortcuts2":"<strong>CTRL + SHIFT + K</strong> to uncomment currently selected text","moreInfoShortcuts3":"<strong>CTRL + ALT + K</strong> to auto format currently selected text","moreInfoShortcuts4":"<strong>CTRL + Q</strong> Expand / Collapse Code Block","moreInfoShortcuts5":"<strong>CTRL + F</strong> to perform a search","moreInfoShortcuts6":"<strong>CTRL + G</strong> to find next","moreInfoShortcuts7":"<strong>CTRL + SHIFT + G</strong> to find previous","moreInfoShortcuts8":"<strong>CTRL + SHIFT</strong> to find and replace","moreInfoShortcuts9":"<strong>CTRL + SHIFT + R</strong> to find and replace all","toolbar":"HTML Iturburua","searchCode":"Search Source (CTRL + F)","replaceCode":"Replace Code (CTRL + SHIFT + F)","autoFormat":"Format Selection (CTRL + ALT + K)","commentSelectedRange":"Comment Selection (CTRL + K)","uncommentSelectedRange":"Uncomment Selection (CTRL + SHIFT + K)","autoCompleteToggle":"Enable/Disable HTML Tag Autocomplete"},"emoji":{"searchPlaceholder":"Search emoji…","searchLabel":"Input field responsible for searching and filtering emoji inside panel.","navigationLabel":"Groups navigation for emoji sections.","title":"Emoji List","groups":{"people":"People","nature":"Nature and animals","food":"Food and drinks","travel":"Travel and places","activities":"Activities","objects":"Objects","symbols":"Symbols","flags":"Flags"}},"html5video":{"button":"Txertatu HTML5 bideoa","title":"HTML5 bideoa","infoLabel":"Bideoaren informazioa","allowed":"Baimendutako fitxategi luzapenak: MP4, WebM, Ogv","urlMissing":"Bideoaren URLak ezin du hutsik egon.","videoProperties":"Bideoaren propietateak","upload":"Kargatu","btnUpload":"Bidali zerbitzarira","advanced":"Aurreratua","autoplay":"Automatikoki erreproduzitu?","allowdownload":"Allow download?","advisorytitle":"Advisory title","yes":"Bai","no":"Ez","controls":"Erakutsi kontrolak?","loop":"Loop?","responsive":"Responsive width","poster":"Thumbnail"},"sourcedialog":{"toolbar":"Iturburua","title":"Iturburua"}};