﻿/*
Copyright (c) 2003-2024, CKSource Holding sp. z o.o. All rights reserved.
For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license/
*/
CKEDITOR.lang['ja']={"application":"Rich Text Editor","editor":"リッチテキストエディタ","editorPanel":"リッチテキストエディタパネル","common":{"editorHelp":"ヘルプは ALT 0 を押してください","browseServer":"サーバブラウザ","url":"URL","protocol":"プロトコル","upload":"アップロード","uploadSubmit":"サーバーに送信","image":"イメージ","form":"フォーム","checkbox":"チェックボックス","radio":"ラジオボタン","textField":"１行テキスト","textarea":"テキストエリア","hiddenField":"不可視フィールド","button":"ボタン","select":"選択フィールド","imageButton":"画像ボタン","notSet":"<なし>","id":"Id","name":"Name属性","langDir":"文字表記の方向","langDirLtr":"左から右 (LTR)","langDirRtl":"右から左 (RTL)","langCode":"言語コード","longDescr":"longdesc属性(長文説明)","cssClass":"スタイルシートクラス","advisoryTitle":"Title属性","cssStyle":"スタイルシート","ok":"OK","cancel":"キャンセル","close":"閉じる","preview":"プレビュー","resize":"ドラッグしてリサイズ","generalTab":"全般","advancedTab":"高度な設定","validateNumberFailed":"値が数値ではありません","confirmNewPage":"変更内容を保存せず、 新しいページを開いてもよろしいでしょうか？","confirmCancel":"オプション設定を変更しました。ダイアログを閉じてもよろしいでしょうか？","options":"オプション","target":"ターゲット","targetNew":"新しいウインドウ (_blank)","targetTop":"最上部ウィンドウ (_top)","targetSelf":"同じウィンドウ (_self)","targetParent":"親ウィンドウ (_parent)","langDirLTR":"左から右 (LTR)","langDirRTL":"右から左 (RTL)","styles":"スタイル","cssClasses":"スタイルシートクラス","width":"幅","height":"高さ","align":"行揃え","left":"左","right":"右","center":"中央","justify":"両端揃え","alignLeft":"左揃え","alignRight":"右揃え","alignCenter":"Align Center","alignTop":"上","alignMiddle":"中央","alignBottom":"下","alignNone":"なし","invalidValue":"不正な値です。","invalidHeight":"高さは数値で入力してください。","invalidWidth":"幅は数値で入力してください。","invalidLength":"Value specified for the \"%1\" field must be a positive number with or without a valid measurement unit (%2).","invalidCssLength":"入力された \"%1\" 項目の値は、CSSの大きさ(px, %, in, cm, mm, em, ex, pt, または pc)が正しいものである/ないに関わらず、正の値である必要があります。","invalidHtmlLength":"入力された \"%1\" 項目の値は、HTMLの大きさ(px または %)が正しいものである/ないに関わらず、正の値である必要があります。","invalidInlineStyle":"入力されたインラインスタイルの値は、\"名前 : 値\" のフォーマットのセットで、複数の場合はセミコロンで区切られている形式である必要があります。","cssLengthTooltip":"ピクセル数もしくはCSSにセットできる数値を入力してください。(px,%,in,cm,mm,em,ex,pt,or pc)","unavailable":"%1<span class=\"cke_accessibility\">, 利用不可能</span>","keyboard":{"8":"Backspace","13":"Enter","16":"Shift","17":"Ctrl","18":"Alt","32":"Space","35":"End","36":"Home","46":"Delete","112":"F1","113":"F2","114":"F3","115":"F4","116":"F5","117":"F6","118":"F7","119":"F8","120":"F9","121":"F10","122":"F11","123":"F12","124":"F13","125":"F14","126":"F15","127":"F16","128":"F17","129":"F18","130":"F19","131":"F20","132":"F21","133":"F22","134":"F23","135":"F24","224":"Command"},"keyboardShortcut":"キーボードショートカット","optionDefault":"Default"},"versionCheck":{"notificationMessage":"This CKEditor %current version is not secure. Consider <a target=\"_blank\" href=\"%link\">upgrading to the latest one</a>, %latest.","consoleMessage":"This CKEditor %current version is not secure. Consider upgrading to the latest one, %latest: %link","aboutDialogInsecureMessage":"This CKEditor %current version is not secure.<br>Consider upgrading to the latest one, %latest:<br><a target=\"_blank\" href=\"%link\">%link</a>","aboutDialogUpgradeMessage":"Consider upgrading to the latest editor version, %latest:<br><a target=\"_blank\" href=\"%link\">%link</a>"},"about":{"copy":"Copyright &copy; $1. All rights reserved.","dlgTitle":"CKEditorについて","moreInfo":"ライセンス情報の詳細はウェブサイトにて確認してください:"},"basicstyles":{"bold":"太字","italic":"斜体","strike":"打ち消し線","subscript":"下付き","superscript":"上付き","underline":"下線"},"bidi":{"ltr":"テキストの向き : 左から右へ","rtl":"テキストの向き : 右から左へ"},"blockquote":{"toolbar":"ブロック引用文"},"notification":{"closed":"通知を閉じました。"},"toolbar":{"toolbarCollapse":"ツールバーを閉じる","toolbarExpand":"ツールバーを開く","toolbarGroups":{"document":"Document","clipboard":"Clipboard/Undo","editing":"Editing","forms":"Forms","basicstyles":"Basic Styles","paragraph":"Paragraph","links":"Links","insert":"Insert","styles":"Styles","colors":"Colors","tools":"Tools"},"toolbars":"編集ツールバー"},"clipboard":{"copy":"コピー","copyError":"ブラウザーのセキュリティ設定によりエディタのコピー操作を自動で実行することができません。実行するには手動でキーボードの(Ctrl/Cmd+C)を使用してください。","cut":"切り取り","cutError":"ブラウザーのセキュリティ設定によりエディタの切り取り操作を自動で実行することができません。実行するには手動でキーボードの(Ctrl/Cmd+X)を使用してください。","paste":"貼り付け","pasteNotification":"Press %1 to paste. Your browser doesn‘t support pasting with the toolbar button or context menu option.","pasteArea":"貼り付け場所","pasteMsg":"Paste your content inside the area below and press OK.","fileFormatNotSupportedNotification":"The ${formats} file format(s) are not supported.","fileWithoutFormatNotSupportedNotification":"The file format is not supported."},"colorbutton":{"auto":"自動","bgColorTitle":"背景色","colors":{"000":"Black","800000":"Maroon","8B4513":"Saddle Brown","2F4F4F":"Dark Slate Gray","008080":"Teal","000080":"Navy","4B0082":"Indigo","696969":"Dark Gray","B22222":"Fire Brick","A52A2A":"Brown","DAA520":"Golden Rod","006400":"Dark Green","40E0D0":"Turquoise","0000CD":"Medium Blue","800080":"Purple","808080":"Gray","F00":"Red","FF8C00":"Dark Orange","FFD700":"Gold","008000":"Green","0FF":"Cyan","00F":"Blue","EE82EE":"Violet","A9A9A9":"Dim Gray","FFA07A":"Light Salmon","FFA500":"Orange","FFFF00":"Yellow","00FF00":"Lime","AFEEEE":"Pale Turquoise","ADD8E6":"Light Blue","DDA0DD":"Plum","D3D3D3":"Light Grey","FFF0F5":"Lavender Blush","FAEBD7":"Antique White","FFFFE0":"Light Yellow","F0FFF0":"Honeydew","F0FFFF":"Azure","F0F8FF":"Alice Blue","E6E6FA":"Lavender","FFF":"White","1ABC9C":"Strong Cyan","2ECC71":"Emerald","3498DB":"Bright Blue","9B59B6":"Amethyst","4E5F70":"Grayish Blue","F1C40F":"Vivid Yellow","16A085":"Dark Cyan","27AE60":"Dark Emerald","2980B9":"Strong Blue","8E44AD":"Dark Violet","2C3E50":"Desaturated Blue","F39C12":"Orange","E67E22":"Carrot","E74C3C":"Pale Red","ECF0F1":"Bright Silver","95A5A6":"Light Grayish Cyan","DDD":"Light Gray","D35400":"Pumpkin","C0392B":"Strong Red","BDC3C7":"Silver","7F8C8D":"Grayish Cyan","999":"Dark Gray"},"more":"その他の色...","panelTitle":"色","textColorTitle":"文字色"},"colordialog":{"clear":"クリア","highlight":"ハイライト","options":"カラーオプション","selected":"選択された色","title":"色選択"},"templates":{"button":"テンプレート","emptyListMsg":"(テンプレートが定義されていません)","insertOption":"現在のエディタの内容と置き換えます","options":"テンプレートオプション","selectPromptMsg":"エディターで使用するテンプレートを選択してください。<br>(現在のエディタの内容は失われます):","title":"内容テンプレート"},"contextmenu":{"options":"コンテキストメニューオプション"},"copyformatting":{"label":"フォーマットをコピー","notification":{"copied":"コピーされたフォーマット","applied":"フォーマットを適用しました","canceled":"フォーマットを取り消しました","failed":"フォーマットのコピーに失敗しました。最初にフォーマットをコピーしてから適用してください。"}},"div":{"IdInputLabel":"Id","advisoryTitleInputLabel":"Title属性","cssClassInputLabel":"スタイルシートクラス","edit":"Divコンテナを編集","inlineStyleInputLabel":"インラインスタイル","langDirLTRLabel":"左から右 (LTR)","langDirLabel":"文字表記の方向","langDirRTLLabel":"右から左 (RTL)","languageCodeInputLabel":" 言語コード","remove":"Divコンテナを削除","styleSelectLabel":"スタイル","title":"Divコンテナを作成","toolbar":"Divコンテナを作成"},"elementspath":{"eleLabel":"要素パス","eleTitle":"%1 要素"},"exportpdf":{"documentReady":"Document is ready!","error":"Error occurred.","processingDocument":"Processing PDF document...","toolbar":"Export to PDF"},"filetools":{"loadError":"ファイルの読み込み中にエラーが発生しました。","networkError":"ファイルのアップロード中にネットワークエラーが発生しました。","httpError404":"ファイルのアップロード中にHTTPエラーが発生しました。(404: File not found)","httpError403":"ファイルのアップロード中にHTTPエラーが発生しました。(403: Forbidden)","httpError":"ファイルのアップロード中にHTTPエラーが発生しました。(error status: %1)","noUrlError":"アップロードURLが定義されていません。","responseError":"サーバーの応答が不正です。"},"find":{"find":"検索","findOptions":"検索オプション","findWhat":"検索する文字列:","matchCase":"大文字と小文字を区別する","matchCyclic":"末尾に逹したら先頭に戻る","matchWord":"単語単位で探す","notFoundMsg":"指定された文字列は見つかりませんでした。","replace":"置換","replaceAll":"すべて置換","replaceSuccessMsg":"%1 個置換しました。","replaceWith":"置換後の文字列:","title":"検索と置換"},"font":{"fontSize":{"label":"サイズ","voiceLabel":"フォントサイズ","panelTitle":"フォントサイズ"},"label":"フォント","panelTitle":"フォント","voiceLabel":"フォント"},"fakeobjects":{"anchor":"アンカー","hiddenfield":"不可視フィールド","iframe":"IFrame","unknown":"Unknown Object"},"forms":{"button":{"title":"ボタン プロパティ","text":"テキスト (値)","type":"タイプ","typeBtn":"ボタン","typeSbm":"送信","typeRst":"リセット"},"checkboxAndRadio":{"checkboxTitle":"チェックボックスのプロパティ","radioTitle":"ラジオボタンのプロパティ","value":"値","selected":"選択済み","required":"必須"},"form":{"title":"フォームのプロパティ","menu":"フォームのプロパティ","action":"アクション (action)","method":"メソッド (method)","encoding":"エンコード方式 (encoding)"},"hidden":{"title":"不可視フィールド プロパティ","name":"名前 (name)","value":"値 (value)"},"select":{"title":"選択フィールドのプロパティ","selectInfo":"情報","opAvail":"利用可能なオプション","value":"選択項目値","size":"サイズ","lines":"行","chkMulti":"複数選択を許可","required":"必須","opText":"選択項目名","opValue":"値","btnAdd":"追加","btnModify":"編集","btnUp":"上へ","btnDown":"下へ","btnSetValue":"選択した値を設定","btnDelete":"削除"},"textarea":{"title":"テキストエリア プロパティ","cols":"列","rows":"行"},"textfield":{"title":"１行テキスト プロパティ","name":"名前","value":"値","charWidth":"サイズ","maxChars":"最大長","required":"必須","type":"タイプ","typeText":"テキスト","typePass":"パスワード入力","typeEmail":"メール","typeSearch":"検索","typeTel":"電話番号","typeUrl":"URL"}},"format":{"label":"書式","panelTitle":"段落の書式","tag_address":"アドレス","tag_div":"標準 (DIV)","tag_h1":"見出し 1","tag_h2":"見出し 2","tag_h3":"見出し 3","tag_h4":"見出し 4","tag_h5":"見出し 5","tag_h6":"見出し 6","tag_p":"標準","tag_pre":"書式付き"},"horizontalrule":{"toolbar":"水平線"},"iframe":{"border":"フレームの枠を表示","noUrl":"iframeのURLを入力してください。","scrolling":"スクロールバーの表示を許可","title":"iFrameのプロパティ","toolbar":"IFrame","tabindex":"Remove from tabindex"},"image":{"alt":"代替テキスト","border":"枠線の幅","btnUpload":"サーバーに送信","button2Img":"選択した画像ボタンを画像に変換しますか？","hSpace":"水平間隔","img2Button":"選択した画像を画像ボタンに変換しますか？","infoTab":"画像情報","linkTab":"リンク","lockRatio":"比率を固定","menu":"画像のプロパティ","resetSize":"サイズをリセット","title":"画像のプロパティ","titleButton":"画像ボタンのプロパティ","upload":"アップロード","urlMissing":"画像のURLを入力してください。","vSpace":"垂直間隔","validateBorder":"枠線の幅は数値で入力してください。","validateHSpace":"水平間隔は数値で入力してください。","validateVSpace":"垂直間隔は数値で入力してください。"},"indent":{"indent":"インデント","outdent":"インデント解除"},"smiley":{"options":"絵文字オプション","title":"顔文字挿入","toolbar":"絵文字"},"language":{"button":"言語を設定","remove":"言語を削除"},"link":{"acccessKey":"アクセスキー","advanced":"高度な設定","advisoryContentType":"Content Type属性","advisoryTitle":"Title属性","anchor":{"toolbar":"アンカー挿入/編集","menu":"アンカーの編集","title":"アンカーのプロパティ","name":"アンカー名","errorName":"アンカー名を入力してください。","errorWhitespace":"Anchor name cannot contain space characters","remove":"アンカーを削除"},"anchorId":"エレメントID","anchorName":"アンカー名","charset":"リンク先のcharset","cssClasses":"スタイルシートクラス","download":"強制的にダウンロード","displayText":"表示文字","emailAddress":"E-Mail アドレス","emailBody":"本文","emailSubject":"件名","id":"Id","info":"ハイパーリンク情報","langCode":"言語コード","langDir":"文字表記の方向","langDirLTR":"左から右 (LTR)","langDirRTL":"右から左 (RTL)","menu":"リンクを編集","name":"Name属性","noAnchors":"(このドキュメント内にアンカーはありません)","noEmail":"メールアドレスを入力してください。","noUrl":"リンクURLを入力してください。","noTel":"Please type the phone number","other":"<その他の>","phoneNumber":"Phone number","popupDependent":"開いたウィンドウに連動して閉じる (Netscape)","popupFeatures":"ポップアップウィンドウ特徴","popupFullScreen":"全画面モード(IE)","popupLeft":"左端からの座標で指定","popupLocationBar":"ロケーションバー","popupMenuBar":"メニューバー","popupResizable":"サイズ可変","popupScrollBars":"スクロールバー","popupStatusBar":"ステータスバー","popupToolbar":"ツールバー","popupTop":"上端からの座標で指定","rel":"関連リンク","selectAnchor":"アンカーを選択","styles":"スタイルシート","tabIndex":"タブインデックス","target":"ターゲット","targetFrame":"<フレーム>","targetFrameName":"ターゲットのフレーム名","targetPopup":"<ポップアップウィンドウ>","targetPopupName":"ポップアップウィンドウ名","title":"ハイパーリンク","toAnchor":"ページ内のアンカー","toEmail":"E-Mail","toUrl":"URL","toPhone":"Phone","toolbar":"リンク挿入/編集","type":"リンクタイプ","unlink":"リンクを削除","upload":"アップロード"},"list":{"bulletedlist":"番号無しリスト","numberedlist":"番号付きリスト"},"liststyle":{"bulletedTitle":"箇条書きのプロパティ","circle":"白丸","decimal":"数字 (1, 2, 3, etc.)","disc":"黒丸","lowerAlpha":"小文字アルファベット (a, b, c, d, e, etc.)","lowerRoman":"小文字ローマ数字 (i, ii, iii, iv, v, etc.)","none":"なし","notset":"<なし>","numberedTitle":"番号付きリストのプロパティ","square":"四角","start":"開始","type":"種類","upperAlpha":"大文字アルファベット (A, B, C, D, E, etc.)","upperRoman":"大文字ローマ数字 (I, II, III, IV, V, etc.)","validateStartNumber":"リストの開始番号は数値で入力してください。"},"magicline":{"title":"ここに段落を挿入"},"maximize":{"maximize":"最大化","minimize":"最小化"},"newpage":{"toolbar":"新しいページ"},"pagebreak":{"alt":"改ページ","toolbar":"印刷の為に改ページ挿入"},"pastetext":{"button":"プレーンテキストとして貼り付け","pasteNotification":"%1 を押して貼り付けます。 ブラウザは、ツールバーボタンまたはコンテキストメニューオプションを使用した貼り付けをサポートしていません。","title":"プレーンテキストとして貼り付け"},"pastefromword":{"confirmCleanup":"貼り付けを行うテキストはワード文章からコピーされようとしています。貼り付ける前にクリーニングを行いますか？","error":"内部エラーにより貼り付けたデータをクリアできませんでした","title":"ワード文章から貼り付け","toolbar":"ワード文章から貼り付け"},"preview":{"preview":"プレビュー"},"print":{"toolbar":"印刷"},"removeformat":{"toolbar":"書式を解除"},"save":{"toolbar":"保存"},"selectall":{"toolbar":"すべて選択"},"showblocks":{"toolbar":"ブロック表示"},"sourcearea":{"toolbar":"ソース"},"specialchar":{"options":"特殊文字オプション","title":"特殊文字の選択","toolbar":"特殊文字を挿入"},"scayt":{"btn_about":"SCAYTﾊﾞｰｼﾞｮﾝ","btn_dictionaries":"辞書","btn_disable":"SCAYT無効","btn_enable":"SCAYT有効","btn_langs":"言語","btn_options":"オプション","text_title":"スペルチェック設定(SCAYT)"},"stylescombo":{"label":"スタイル","panelTitle":"スタイル","panelTitle1":"ブロックスタイル","panelTitle2":"インラインスタイル","panelTitle3":"オブジェクトスタイル"},"table":{"border":"枠線の幅","caption":"キャプション","cell":{"menu":"セル","insertBefore":"セルを前に挿入","insertAfter":"セルを後に挿入","deleteCell":"セルを削除","merge":"セルを結合","mergeRight":"右に結合","mergeDown":"下に結合","splitHorizontal":"セルを水平方向に分割","splitVertical":"セルを垂直方向に分割","title":"セルのプロパティ","cellType":"セルの種類","rowSpan":"行の結合数","colSpan":"列の結合数","wordWrap":"単語の折り返し","hAlign":"水平方向の配置","vAlign":"垂直方向の配置","alignBaseline":"ベースライン","bgColor":"背景色","borderColor":"ボーダーカラー","data":"テーブルデータ (td)","header":"ヘッダ","columnHeader":"Column Header","rowHeader":"Row Header","yes":"はい","no":"いいえ","invalidWidth":"セル幅は数値で入力してください。","invalidHeight":"セル高さは数値で入力してください。","invalidRowSpan":"縦幅(行数)は数値で入力してください。","invalidColSpan":"横幅(列数)は数値で入力してください。","chooseColor":"色の選択"},"cellPad":"セル内間隔","cellSpace":"セル内余白","column":{"menu":"列","insertBefore":"列を左に挿入","insertAfter":"列を右に挿入","deleteColumn":"列を削除"},"columns":"列数","deleteTable":"表を削除","headers":"ヘッダ (th)","headersBoth":"両方","headersColumn":"最初の列のみ","headersNone":"なし","headersRow":"最初の行のみ","heightUnit":"height unit","invalidBorder":"枠線の幅は数値で入力してください。","invalidCellPadding":"セル内余白は数値で入力してください。","invalidCellSpacing":"セル間余白は数値で入力してください。","invalidCols":"列数は0より大きな数値を入力してください。","invalidHeight":"高さは数値で入力してください。","invalidRows":"行数は0より大きな数値を入力してください。","invalidWidth":"幅は数値で入力してください。","menu":"表のプロパティ","row":{"menu":"行","insertBefore":"行を上に挿入","insertAfter":"行を下に挿入","deleteRow":"行を削除"},"rows":"行数","summary":"表の概要","title":"表のプロパティ","toolbar":"表","widthPc":"パーセント","widthPx":"ピクセル","widthUnit":"幅の単位"},"undo":{"redo":"やり直す","undo":"元に戻す"},"widget":{"move":"ドラッグして移動","label":"%1 ウィジェット"},"uploadwidget":{"abort":"アップロードを中止しました。","doneOne":"ファイルのアップロードに成功しました。","doneMany":"%1個のファイルのアップロードに成功しました。","uploadOne":"ファイルのアップロード中 ({percentage}%)...","uploadMany":"{max} 個中 {current} 個のファイルをアップロードしました。 ({percentage}%)..."},"a11yfirsthelp":{"label":"A11yFirst Help","panelTitle":"Learn about A11yFirst features","keyboardShortcutsLabel":"Keyboard Shortcuts","versionLabel":"Version","a11yFirstHelpLabel":"A11yFirst Help: Content Accessibility","a11yFirstHelpTitle":"Information to help authors understand how the A11yFirst features help them make content more accessible to people with disabilites","headingHelp":{"menu":"Heading / Paragraph","label":"Heading / Paragraph","title":"Heading / Paragraph Help","content":"## Heading / Paragraph\n\n### Menu items\n* **H1 – Document title** — Typically should be the first heading in the\n  document and used only once.\n* **H2 – Section title** — Describes a main or top-level section in the\n  document.\n* **H3 to H6 – Subsection title** — Describes a subsection within a top-level\n  section or other subsection of the document.\n* **Normal** — The default paragraph format, typically with significant top\n  and bottom margins.\n* **Preformatted text** — Use this for computer code blocks to maintain spacing\n  and indentation.\n* **Address line** — Use this to type a series of address lines styled in\n  italics and with minimal top and bottom margins. When you press enter at the\n  end of a line, the next line is also an address line.\n\n### About headings\n* The Heading / Paragraph menu only enables the **allowed** heading levels.\n\n* The cursor position relative to other headings in the document determines\nwhich heading levels are allowed.\n\n### About paragraph formats\n* Visual styling for paragraph formats is predetermined by your organization,\nthus freeing up your time and energy for concentrating on the structure and\nmeaning of the content within your document.\n\n### Why headings and paragraph formats are important\n* The purpose of a heading is to label the content that follows it.\n\n* The proper nesting of heading levels improves the ability of all users to\nfind and comprehend information on a page.\n\n* Headings used consistently and in meaningful ways improve Search Engine\nOptimization (SEO).\n\n* Properly nested headings enable people using assistive technologies to easily\nnavigate to each section of a document.\n\n* When paragraph formats are used properly (e.g. *Preformatted* or *Address*),\nthey help users of assistive technologies understand the intended role of the\ncontent.\n\n* Thinking in terms of blocks such as headings and paragraph formats within\nyour document is a higher-level approach to providing structure and semantics\nthat are important for all users.\n\n### More information\n* Documents are easier to read and understand when headings identify the topics\nthey contain.\n\n* Headings make it easier to scan and find topics of interest within a document.\n\n* Heading levels identify the structural relationships between sections of\ncontent in a document.\n\n* Higher-level headings (Levels 1 and 2) identify the main topics of a document\nand lower-level headings (Levels 3, 4, 5 and 6) identify subsections of the\ndocument.\n\n* A subsection is identified by using the next lower-level heading. For\nexample, subsections of Level 2 headings use Level 3 headings, subsections of\nLevel 3 headings use Level 4 headings, and so on to Level 6 headings.\n\n* Break content into subsections when there are two or more ideas or concepts\nthat correspond to the topics covered in the section. Use headings of the same\nlevel to label each subsection.\n\n* Heading levels should **never** be used for inline visual styling of content\n(e.g. larger or smaller font size, bold or italic). Instead, use the `Inline\nStyle` options.\n"},"listHelp":{"menu":"List","label":"List","title":"List Help","content":"## List\n\n### Working with lists\n\n<img style=\"padding: 8px 0 3px 5px\" alt=\"list toolbar buttons\"\nsrc=\"basePath/plugins/a11yfirsthelp/images/list-buttons.png\"/>\n\nUse the toolbar buttons shown above to:\n\n* Insert/Remove Numbered List\n* Insert/Remove Bulleted List\n* Increase Indent\n* Decrease Indent\n\n### List properties via context menu\n\nThe context menu allows further configuration of list properties such as\nnumbering and bullet types by selecting:\n\n* Numbered List Properties\n* Bulleted List Properties\n\nThe context menu can be invoked by positioning the cursor in a list item and:\n\n* right-clicking, using the mouse, or\n* using Mouse Keys on Windows or Mac.\n\n### About lists\n\n* Use a numbered list when the order or sequence of the items is significant.\n* Use a bulleted list when the order of the items is not significant.\n\n### Why lists are important\n\n* Lists convey grouping semantics for related items.\n* Lists may also convey hierarchical structure.\n* When related items are grouped as a list, information about the list is\n  conveyed to screen reader users, including the type of list, the number of\n  items it contains and the sequence number of the current list item.\n"},"imageHelp":{"menu":"Image","label":"Image","title":"Image Help","content":"## Image\n\n### Accessible image descriptions\n\n* People with visual impairments or visual processing disorders need\n  accessible text descriptions of informative images.\n\n* There are two types of accessible descriptions for images: *alternative\n  text* and *long descriptions*.\n\n### Alternative text\n\n* Succinctly describes the content and function of the image for people\n  with visual impairments, in no more than 100 characters\n\n* Is required for informative images (but not for images that are purely\n  decorative)\n\n* Is not visible in the document; it is communicated to screen reader users\n  via the *img* element's *alt* attribute\n\n* For a purely decorative image, select the **‘Image does not require\n  alternative text’** checkbox and leave the alternative text field blank.\n\n### Long descriptions for complex images\n\n* A complex image has informational content that cannot be described adequately\n  by alternative text of 100 characters or less.\n\n* Examples of complex images include charts, graphs, diagrams, scientific\n  photographs and works of art.\n\n* A complex image needs both a concise alternative text description and a\n  longer, more detailed description.\n\n* Accessibility requirements mandate that the long description of a complex\n  image be placed in the document adjacent to the image.\n\n### Adding a long description in the document\n\nFollow these steps when adding a long description of a complex image:\n\n1. Add an adequately detailed description of the image within the document,\n   either just before or after the image (or both).\n\n1. In answer to the question **‘Is a long description needed, and if so,\n   where will it be located’**, select one of the following:\n       * Yes; in the document before the image\n       * Yes; in the document after the image\n       * Yes; in the document before and after the image\n\nBy specifying the location of the long description relative to the image,\nscreen reader users will be informed of its existence and location in the\ndocument. (This information is appended to the alternative text.)\n\n### Insert a caption text box below the image\n\n* A **caption** is an optional visual label supported by CKEditor for an image.\n  It provides an additional way to describe an image that is immediately below\n  and proximate to the image.\n\n* The caption content is specified and is editable in the text box just below\n  the image, once it has been inserted in the document.\n\n* From an accessibility perspective the *caption* and the *alternative text*\n  should not be the same, but instead should complement each other.\n\n* Using the caption creates a *figcaption* element contained in a *figure*\n  element. The *figure* element also contains the *img* element.\n\n### Writing effective alternative text\n\nThe following are based on <a href=\"https://webaim.org\" target=\"_resource\">\nWebAIM</a>'s guidelines for alternative text:\n\n* **Be accurate and equivalent** in presenting the same *content* and\n  *function* of the image.\n\n* When **images are used as links**, the alternative text should describe the\n  target of the link.\n\n* **Be succinct.** This means the correct content and function of the image\n  should be presented as succinctly as is appropriate. Typically no more than\n  a few words are necessary, though rarely a short sentence or two may be\n  appropriate. The length should not exceed 100 characters.\n\n* **Do NOT be redundant** or provide the same information as text that is\n  already part of the document.\n\n* **Do NOT use the phrases “image of ...” or “graphic of ...”** to describe\n  the image. Assistive technologies notify the user of the image.  It is your\n  job to describe the purpose or the content of the image.  If the image is a\n  photograph or illustration, etc. of important content, it may be useful to\n  include this in the alternative text.\n\n* **Do NOT include file names or sizes** as part of the alternative text.\n\n### Why image descriptions are important\n\nAdding text descriptions of images is an important part of making documents\naccessible to the visually impaired who use assistive devices such as screen\nreaders and magnifiers, and to people with visual processing disorders, which\nmake especially complex images more difficult to understand.\n\nWhen the user cannot see all or part of an image, assistive technologies will\nread or display its alternative text description. This is especially important\nwhen the image conveys information that is required for the user to fully\nunderstand the information in the document.\n\nFor people with visual processing disorders, a detailed description of a\ncomplex image helps them to more quickly or completely understand the\ninformation being conveyed by the image.\n\n### More information\n\n* <a href=\"https://accessibility.psu.edu/images/alttext/\"\ntarget=\"_resource\">Penn State: Image ALT Text</a>\n\n* <a href=\"https://webaim.org/techniques/alttext/\"\ntarget=\"_resource\">WebAIM: Alternative Text</a>\n\n* <a href=\"https://www.w3.org/WAI/tutorials/images/\"\ntarget=\"_resource\">W3C Web Accessibility Image Tutorial</a>\n\n* <a href=\"http://diagramcenter.org/\" target=\"_resource\">Diagram Center</a>\n"},"inlineStyleHelp":{"menu":"Character Style","label":"Character Style","title":"Character Style Help","content":"## Character Style\n\n### Working with character styles\n\n* To apply a character style to existing text, select a range of text and then\nchoose an option from the menu.\n\n* To apply a character style to text you are about to type, choose an option\nfrom the menu and begin typing. The style will continue to be applied until\nyou choose another option or move the cursor to a different point in the\ndocument.\n\n* Multiple character styles can be applied to selected text.\n\n### About character styles\n\n* Character styles have a different purpose than paragraph formats. They are\nused at a lower level to highlight words or phrases within blocks of text.\n\n* Character styles, when used properly, help screen reader users better\nunderstand the types and meanings of lower-level stylistic changes within\nblocks of text.\n\n### Character styles vs. headings, lists and paragraph formats\n\n* Thinking in terms of headings, lists and paragraph formats first, and then\nusing character styles to emphasize key words or phrases within text blocks,\nresults in documents that are easier to read and understand.\n\n* When headings, lists and paragraph formats are considered as primary, and\ncharacter styles secondary, many visual styling decisions can be avoided, as\nthey are already made by default.\n\n* When character styles are used to change the styling of blocks of text\nwithout regard to whether the block is a heading, list item or other type of\nparagraph format, it makes the document more difficult to read and understand\nwithin the context of the website.\n\n* Using headings, lists, paragraph formats and character styles properly will\nmake it easier for you to maintain stylistic consistency.\n"},"linkHelp":{"menu":"Link","label":"Link","title":"Link Help","content":"## Link\n\n### Display Text\n\nProviding accessible *Display Text* is straightforward if you keep the\nfollowing guidelines in mind:\n\n1. The *Display Text* for a link should describe the target of the link.\n\n1. Do not use ambiguous text, such as “Click Here” or “More”.\n\n1. Do not begin the *Display Text* with redundant words or phrases such as\n   “Link” or “Link to”.\n\n1. Be consistent: Links to the same URL or e-mail address should have the same\n   *Display Text*.\n\n1. In most cases, it is best not to use the link URL or e-mail address as the\n   *Display Text*.\n\n### About links\n\n* Screen reader users often use the “List of Links” feature to identify and\n  navigate to links on a page. When links are presented as a list,  using\n  descriptive *Display Text* becomes even more important since understanding\n  the target of each link no longer benefits from its original context within\n  the document.\n\n* Screen reader users often use the “Search” feature to find links on a page\n  based on keywords they would expect to find in the *Display Text* of the\n  links. Thus the more descriptive the link *Display Text*, the more effective\n  the search feature will be in finding relevant links.\n\n* Usable and accessible *Display Text* should be descriptive, unique and start\n  with keywords (NNG).\n\n* The *Display Text* for links is like a sign post. It should tell you what\n  you’ll find when you follow it (NOMENSA).\n\n### Why links are important\n\n* Descriptive link text makes it easier for everyone to find and follow links\n  on a page that are of interest to them.\n\n* Descriptive link text is especially important for people using screen\n  readers, who typically only hear the display text spoken to them through\n  speech synthesis and do not \"see\" the link in the context of other content\n  on the page.\n\n* When URLs, e-mail addresses or other ambiguous text are used as the display\n  text for a link, it is impossible in many cases, and much more difficult in\n  the remaining cases, for screen reader users to find and follow links of\n  interest to them.\n\n### More information\n\n* <a href=\"https://www.nngroup.com/articles/writing-links/\"\ntarget=\"_resource\">NNG: Writing Hyperlinks: Salient, Descriptive, Start with\nKeyword</a>\n\n* <a href=\"https://www.nomensa.com/blog/2011/writing-good-link-text\"\ntarget=\"_resource\">Nomensa: How to write good link text</a>\n\n* <a href=\"https://accessibility.umn.edu/core-skills/hyperlinks\"\ntarget=\"_resource\">Accessible U: Hyperlinks (Good and Bad Examples)</a>\n"},"gettingStarted":{"menu":"Getting Started","label":"Getting Started","title":"Getting Started with A11yFirst","content":"## Getting Started with A11yFirst\n\n### What is A11yFirst?\n\nBefore you begin using the A11yFirst editor, it is important to know what\nmakes it different from other editors. The name *A11yFirst* hints at some\nof these differences.\n\n*A11y* is shorthand for *accessibility* (*a* + 11 letters + *y*), and\naccessibility in the context of document authoring is about making the\ninformation that documents contain perceivable and understandable by everyone,\nincluding people with disabilities.</p>\n\n### Commitment to accessibility\n\nYour organization, by hosting the A11yFirst editor within its content\nmanagement system, has made a commitment to accessibility because (1) it\nremoves barriers that people with visual, auditory, learning and other\ndisabilities may experience in their use of web information and communication\ntechnologies and (2) it is required by law.\n\nBy following accessibility guidelines when creating public-facing documents,\nyou are fulfilling your role in this commitment.\n\n### Document accessibility\n\nSome of the main components within a document that are important for\naccessibility are:\n\n* **Headings** — These provide titles for the sections and subsections of\ncontent within your document, as well as a title for the document itself.\n\n* **Lists** — By using the list feature, the items in a list are grouped\ntogether and information about the grouping can be conveyed to users of\nassistive technologies.\n\n* **Links** — The text component of a link should describe its target, i.e.,\nthe web site, page or section that will be displayed if you activate the link.\n\n* **Images** — When an image with informational content is included within a\ndocument, a short text description (also known as ‘alt text’) allows screen\nreader users to obtain a concise description of the image.\n\n* **Tables** — By using the table feature to organize tabular data and provide row\nand column headers, users of assistive technologies gain the ability to easily\nnavigate and understand structural relationships within the data.\n\n### A different way of thinking\n\nThe way you think about the process or workflow of creating and editing\ndocuments can make a significant difference in whether the end result, your\nfinished document, is accessible.\n\nFor example, rather than thinking about stylistic considerations such as font\nsizes and colors first, if you make the structure of your document a primary\nconsideration, by breaking it down into sections and subsections and giving\neach of these a meaningful title, you will end up with a document that will\nbe easier for all users to navigate and understand, including people with\ndisabilities.\n"},"aboutA11yFirst":{"menu":"About A11yFirst","label":"About A11yFirst","title":"Description of A11yFirst Project","content":"## About A11yFirst\n\n### Project Description & Goals\n\nThe A11yFirst Project is a collection of modifications to CKEditor, an\nHTML-embedded WYSIWYG editor typically used within content management\nsystems. Its goal is to make the process of creating and editing web documents\none that proactively results in accessible content.\n\nIn the past, authors have had to rely upon remediation tools used at the end\nof the authoring process that ‘fix’ accessibility problems without offering\nmuch guidance on how to prevent them. The A11yFirst editor takes a different\napproach.\n\nFor example, by prompting the author to provide information regarding links\nand images as they are added to the document, accessibility problems are not\nonly avoided, but authors learn on a feature-by-feature basis some of the\nimportant requirements for accessible content.\n\nOther design features in A11yFirst promote the use of blocks such as headings\nand lists that carry with them semantics that are communicated to screen\nreader users and that result in documents that are more easily navigated and\nunderstood by all readers.\n\n### Project Information\n\n* Version: %version\n\n* GitHub Repositories: <a href=\"https://github.com/a11yfirst\"\ntarget=\"_resource\">https://github.com/a11yfirst</a>\n\n### Contributors\n\n* Lucy Chang     (UX, Usability Testing)\n* Jon Gunderson  (Requirements, Development, Usability Testing,\n  Project Management)\n* Nicholas Hoyt  (UX, UI Design, Development, Usability Testing,\n  Project Management)\n* JaEun Jemma Ku (Requirements, Usability Testing, UI Design,\n  Project Management)\n* Eileen Lopez   (UX, Usability Testing)\n* Mark McCarthy  (UX, Usability Testing)\n* Robert Slater  (Requirements)\n* Dena Strong    (UX, Usability Testing)\n\n### Sponsors\n\n* Disability Resources and Educational Services (DRES), College of Applied\n  Health Sciences (AHS), University of Illinois at Urbana-Champaign\n* Illinois Extension, College of Agricultural, Consumer and Environmental\n  Sciences (ACES), University of Illinois at Urbana-Champaign\n* The University Library, Innovation Fund (Jemma Ku, P.I.), University of\n  Illinois at Urbana-Champaign\n* Administrative Information Technology Services (AITS), University of\n  Illinois at Urbana-Champaign\n* School of Information Sciences (iSchool), University of Illinois at\n  Urbana-Champaign\n\n### Acknowledgements\n\nMany of the ideas and motivations for the A11yFirst Project were the result\nof work done previously by a group of software developers at the Illinois\nDepartment of Human Services (DHS), led by Mike Scott, who created the OneNet\ncontent management system, which includes as its centerpiece an accessible\nWYSIWYG editor.\n\nThe OneNet CMS has been in use by the Illinois DHS since 2006 to promote\naccessible authoring for their intranet and main website.\n\nMr. Scott also participated in the requirements gathering phase of the\nA11yFirst Project.\n"}},"codemirror":{"copyright":"Copyright CodeMirror © Marijn Haverbeke. All rights reserved.","dlgTitle":"About CodeMirror Source Plugin","moreInfoShortcuts":"Available Shortcuts","moreInfoShortcuts1":"<strong>CTRL + K</strong> to comment the currently selected text","moreInfoShortcuts2":"<strong>CTRL + SHIFT + K</strong> to uncomment currently selected text","moreInfoShortcuts3":"<strong>CTRL + ALT + K</strong> to auto format currently selected text","moreInfoShortcuts4":"<strong>CTRL + Q</strong> Expand / Collapse Code Block","moreInfoShortcuts5":"<strong>CTRL + F</strong> to perform a search","moreInfoShortcuts6":"<strong>CTRL + G</strong> to find next","moreInfoShortcuts7":"<strong>CTRL + SHIFT + G</strong> to find previous","moreInfoShortcuts8":"<strong>CTRL + SHIFT</strong> to find and replace","moreInfoShortcuts9":"<strong>CTRL + SHIFT + R</strong> to find and replace all","toolbar":"ソース","searchCode":"Search Source (CTRL + F)","replaceCode":"Replace Code (CTRL + SHIFT + F)","autoFormat":"Format Selection (CTRL + ALT + K)","commentSelectedRange":"Comment Selection (CTRL + K)","uncommentSelectedRange":"Uncomment Selection (CTRL + SHIFT + K)","autoCompleteToggle":"Enable/Disable HTML Tag Autocomplete"},"emoji":{"searchPlaceholder":"Search emoji…","searchLabel":"Input field responsible for searching and filtering emoji inside panel.","navigationLabel":"Groups navigation for emoji sections.","title":"Emoji List","groups":{"people":"People","nature":"Nature and animals","food":"Food and drinks","travel":"Travel and places","activities":"Activities","objects":"Objects","symbols":"Symbols","flags":"Flags"}},"html5video":{"button":"Insert HTML5 video","title":"HTML5 video","infoLabel":"Video info","allowed":"Allowed file extensions: MP4, WebM, Ogv","urlMissing":"Video source URL is missing.","videoProperties":"Video properties","upload":"Upload","btnUpload":"Send it to the server","advanced":"Advanced","autoplay":"Autoplay?","allowdownload":"Allow download?","advisorytitle":"Advisory title","yes":"Yes","no":"No","loop":"Loop?","responsive":"Responsive width","controls":"Show controls","poster":"Thumbnail"},"sourcedialog":{"toolbar":"ソース","title":"ソース"}};