﻿/*
Copyright (c) 2003-2024, CKSource Holding sp. z o.o. All rights reserved.
For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license/
*/
CKEDITOR.lang['lv']={"application":"Rich Text Editor","editor":"Bagātinātā teksta redaktors","editorPanel":"Bagātinātā teksta redaktora panelis","common":{"editorHelp":"Palīdzībai, nospiediet ALT 0 ","browseServer":"Skatīt servera saturu","url":"URL","protocol":"Protokols","upload":"Augšupielādēt","uploadSubmit":"Nosūtīt serverim","image":"Attēls","form":"Forma","checkbox":"Atzīmēšanas kastīte","radio":"Izvēles poga","textField":"Teksta rinda","textarea":"Teksta laukums","hiddenField":"Paslēpta teksta rinda","button":"Poga","select":"Iezīmēšanas lauks","imageButton":"Attēlpoga","notSet":"<nav iestatīts>","id":"Id","name":"Nosaukums","langDir":"Valodas lasīšanas virziens","langDirLtr":"No kreisās uz labo (LTR)","langDirRtl":"No labās uz kreiso (RTL)","langCode":"Valodas kods","longDescr":"Gara apraksta Hipersaite","cssClass":"Stilu saraksta klases","advisoryTitle":"Konsultatīvs virsraksts","cssStyle":"Stils","ok":"Darīts!","cancel":"Atcelt","close":"Aizvērt","preview":"Priekšskatījums","resize":"Mērogot","generalTab":"Vispārīgi","advancedTab":"Izvērstais","validateNumberFailed":"Šī vērtība nav skaitlis","confirmNewPage":"Jebkuras nesaglabātās izmaiņas tiks zaudētas. Vai tiešām vēlaties atvērt jaunu lapu?","confirmCancel":"Daži no uzstādījumiem ir mainīti. Vai tiešām vēlaties aizvērt šo dialogu?","options":"Uzstādījumi","target":"Mērķis","targetNew":"Jauns logs (_blank)","targetTop":"Virsējais logs (_top)","targetSelf":"Tas pats logs (_self)","targetParent":"Avota logs (_parent)","langDirLTR":"Kreisais uz Labo (LTR)","langDirRTL":"Labais uz Kreiso (RTL)","styles":"Stils","cssClasses":"Stilu klases","width":"Platums","height":"Augstums","align":"Nolīdzināt","left":"Pa kreisi","right":"Pa labi","center":"Centrēti","justify":"Izlīdzināt malas","alignLeft":"Izlīdzināt pa kreisi","alignRight":"Izlīdzināt pa labi","alignCenter":"Centrēt","alignTop":"Augšā","alignMiddle":"Vertikāli centrēts","alignBottom":"Apakšā","alignNone":"Nekas","invalidValue":"Nekorekta vērtība","invalidHeight":"Augstumam jābūt skaitlim.","invalidWidth":"Platumam jābūt skaitlim","invalidLength":"Laukam \"%1\" norādītajai vērtībai jābūt pozitīvam skaitlim ar vai bez korektām mērvienībām (%2).","invalidCssLength":"Laukam \"%1\" norādītajai vērtībai jābūt pozitīvam skaitlim ar vai bez korektām CSS mērvienībām (px, %, in, cm, mm, em, ex, pt, vai pc).","invalidHtmlLength":"Laukam \"%1\" norādītajai vērtībai jābūt pozitīvam skaitlim ar vai bez korektām HTML mērvienībām (px vai %).","invalidInlineStyle":"Iekļautajā stilā norādītajai vērtībai jāsastāv no viena vai vairākiem pāriem pēc formāta \"nosaukums: vērtība\", atdalītiem ar semikolu.","cssLengthTooltip":"Ievadiet vērtību pikseļos vai skaitli ar derīgu CSS mērvienību (px, %, in, cm, mm, em, ex, pt, vai pc).","unavailable":"%1<span class=\"cke_accessibility\">, nav pieejams</span>","keyboard":{"8":" atkāpšanās taustiņš","13":"Ievadīt","16":"pārslēgšanas taustiņš","17":"vadīšanas taustiņš","18":"alternēšanas taustiņš","32":"Atstarpe","35":"Beigas","36":"Mājup","46":"Dzēst","112":"F1","113":"F2","114":"F3","115":"F4","116":"F5","117":"F6","118":"F7","119":"F8","120":"F9","121":"F10","122":"F11","123":"F12","124":"F13","125":"F14","126":"F15","127":"F16","128":"F17","129":"F18","130":"F19","131":"F20","132":"F21","133":"F22","134":"F23","135":"F24","224":"Komanda"},"keyboardShortcut":"Klaviatūras saīsne","optionDefault":"Noklusēts"},"versionCheck":{"notificationMessage":"This CKEditor %current version is not secure. Consider <a target=\"_blank\" href=\"%link\">upgrading to the latest one</a>, %latest.","consoleMessage":"This CKEditor %current version is not secure. Consider upgrading to the latest one, %latest: %link","aboutDialogInsecureMessage":"This CKEditor %current version is not secure.<br>Consider upgrading to the latest one, %latest:<br><a target=\"_blank\" href=\"%link\">%link</a>","aboutDialogUpgradeMessage":"Consider upgrading to the latest editor version, %latest:<br><a target=\"_blank\" href=\"%link\">%link</a>"},"about":{"copy":"Kopēšanas tiesības &copy; $1. Visas tiesības rezervētas.","dlgTitle":"Par CKEditor 4","moreInfo":"Informācijai par licenzēšanu apmeklējiet mūsu mājas lapu:"},"basicstyles":{"bold":"Treknraksts","italic":"Slīpraksts","strike":"Pārsvītrojums","subscript":"Apakšraksts","superscript":"Augšraksts","underline":"Pasvītrojums"},"bidi":{"ltr":"Teksta virziens no kreisās uz labo","rtl":"Teksta virziens no labās uz kreiso"},"blockquote":{"toolbar":"Bloka citāts"},"notification":{"closed":"Paziņojums aizvērts."},"toolbar":{"toolbarCollapse":"Aizvērt rīkjoslu","toolbarExpand":"Atvērt rīkjoslu","toolbarGroups":{"document":"Dokuments","clipboard":"Starpliktuve/Atcelt","editing":"Labošana","forms":"Formas","basicstyles":"Pamata stili","paragraph":"Paragrāfs","links":"Saites","insert":"Ievietot","styles":"Stili","colors":"Krāsas","tools":"Rīki"},"toolbars":"Redaktora rīkjoslas"},"clipboard":{"copy":"Kopēt","copyError":"Jūsu pārlūkprogrammas drošības iestatījumi nepieļauj redaktoram automātiski veikt kopēšanas darbību.  Lūdzu, izmantojiet (Ctrl/Cmd+C), lai veiktu šo darbību.","cut":"Izgriezt","cutError":"Jūsu pārlūkprogrammas drošības iestatījumi nepieļauj redaktoram automātiski veikt izgriezšanas darbību.  Lūdzu, izmantojiet (Ctrl/Cmd+X), lai veiktu šo darbību.","paste":"Ielīmēt","pasteNotification":"Nospied %1 lai ielīmētu. Tavs pārlūks neatbalsta ielīmēšanu ar rīkjoslas pogām vai uznirstošās izvēlnes opciju.","pasteArea":"Ielīmēšanas zona","pasteMsg":"Ielīmē saturu zemāk esošajā laukā un nospied OK.","fileFormatNotSupportedNotification":"The ${formats} file format(s) are not supported.","fileWithoutFormatNotSupportedNotification":"The file format is not supported."},"colorbutton":{"auto":"Automātiska","bgColorTitle":"Fona krāsa","colors":{"000":"Melns","800000":"Sarkanbrūns","8B4513":"Sedlu brūns","2F4F4F":"Tumšas tāfeles pelēks","008080":"Zili-zaļš","000080":"Jūras","4B0082":"Indigo","696969":"Tumši pelēks","B22222":"Ķieģeļsarkans","A52A2A":"Brūns","DAA520":"Zelta","006400":"Tumši zaļš","40E0D0":"Tirkīzs","0000CD":"Vidēji zils","800080":"Purpurs","808080":"Pelēks","F00":"Sarkans","FF8C00":"Tumši oranžs","FFD700":"Zelta","008000":"Zaļš","0FF":"Tumšzils","00F":"Zils","EE82EE":"Violets","A9A9A9":"Pelēks","FFA07A":"Gaiši laškrāsas","FFA500":"Oranžs","FFFF00":"Dzeltens","00FF00":"Laima","AFEEEE":"Gaiši tirkīza","ADD8E6":"Gaiši zils","DDA0DD":"Plūmju","D3D3D3":"Gaiši pelēks","FFF0F5":"Lavandas sārts","FAEBD7":"Antīki balts","FFFFE0":"Gaiši dzeltens","F0FFF0":"Meduspile","F0FFFF":"Debesszils","F0F8FF":"Alises zils","E6E6FA":"Lavanda","FFF":"Balts","1ABC9C":"Spēcīgs ciāna","2ECC71":"Smaragds","3498DB":"Koši zils","9B59B6":"Ametists","4E5F70":"Pelēkzils","F1C40F":"Spilgti dzeltens","16A085":"Tumšs ciāna","27AE60":"Tumšs smaragds","2980B9":"Spēcīgi zils","8E44AD":"Tumši violets","2C3E50":"Bāli zils","F39C12":"Apelsīnu","E67E22":"Burkānu","E74C3C":"Blāvi sarkans","ECF0F1":"Spilgti sudraba","95A5A6":"Gaišs pelēki ciāna","DDD":"Gaiši pelēks","D35400":"Ķirbja","C0392B":"Spēcīgi sarkans","BDC3C7":"Sudraba","7F8C8D":"Pelēcīgs ciāna","999":"Tumši pelēks"},"more":"Plašāka palete...","panelTitle":"Krāsa","textColorTitle":"Teksta krāsa"},"colordialog":{"clear":"Notīrīt","highlight":"Paraugs","options":"Krāsas uzstādījumi","selected":"Izvēlētā krāsa","title":"Izvēlies krāsu"},"templates":{"button":"Sagataves","emptyListMsg":"(Nav norādītas sagataves)","insertOption":"Aizvietot pašreizējo saturu","options":"Sagataves uzstādījumi","selectPromptMsg":"Lūdzu, norādiet sagatavi, ko atvērt editorā<br>(patreizējie dati tiks zaudēti):","title":"Satura sagataves"},"contextmenu":{"options":"Uznirstošās izvēlnes uzstādījumi"},"copyformatting":{"label":"Kopēt formatējumu","notification":{"copied":"Formatējums nokopēts","applied":"Formatējums uzstādīts","canceled":"Formatējums atcelts","failed":"Formatēšana neizdevās. Nevar uzstādīt stilus bez to nokopēšanas."}},"div":{"IdInputLabel":"Id","advisoryTitleInputLabel":"Konsultatīvs virsraksts","cssClassInputLabel":"Stilu klases","edit":"Labot Div","inlineStyleInputLabel":"Iekļautais stils","langDirLTRLabel":"Kreisais uz Labo (LTR)","langDirLabel":"Valodas virziens","langDirRTLLabel":"Labais uz kreiso (RTL)","languageCodeInputLabel":"Valodas kods","remove":"Noņemt Div","styleSelectLabel":"Stils","title":"Izveidot div konteineri","toolbar":"Izveidot div konteineri"},"elementspath":{"eleLabel":"Elementa ceļš","eleTitle":"%1 elements"},"exportpdf":{"documentReady":"Document is ready!","error":"Error occurred.","processingDocument":"Processing PDF document...","toolbar":"Export to PDF"},"filetools":{"loadError":"Radās kļūda nolasot failu.","networkError":"Radās tīkla kļūda, kamēr tika ielādēts fails.","httpError404":"Ielādējot failu, radās HTTP kļūda (404: Fails nav atrasts)","httpError403":"Ielādējot failu, radās HTTP kļūda (403: Pieeja liegta)","httpError":"Ielādējot failu, radās HTTP kļūda (kļūdas statuss: %1)","noUrlError":"Augšupielādes adrese nav norādīta.","responseError":"Nekorekta servera atbilde."},"find":{"find":"Meklēt","findOptions":"Meklēt uzstādījumi","findWhat":"Meklēt:","matchCase":"Reģistrjūtīgs","matchCyclic":"Sakrist cikliski","matchWord":"Jāsakrīt pilnībā","notFoundMsg":"Norādītā frāze netika atrasta.","replace":"Nomainīt","replaceAll":"Aizvietot visu","replaceSuccessMsg":"%1 gadījums(i) aizvietoti","replaceWith":"Nomainīt uz:","title":"Meklēt un aizvietot"},"font":{"fontSize":{"label":"Lielums","voiceLabel":"Fonta lielums","panelTitle":"Fonta lielums"},"label":"Fonts","panelTitle":"Fonta nosaukums","voiceLabel":"Fonts"},"fakeobjects":{"anchor":"Iezīme","hiddenfield":"Slēpts lauks","iframe":"Iframe","unknown":"Nezināms objekts"},"forms":{"button":{"title":"Pogas īpašības","text":"Teksts (vērtība)","type":"Tips","typeBtn":"Poga","typeSbm":"Nosūtīt","typeRst":"Atcelt"},"checkboxAndRadio":{"checkboxTitle":"Atzīmēšanas kastītes īpašības","radioTitle":"Izvēles poga īpašības","value":"Vērtība","selected":"Iezīmēts","required":"Obligāts"},"form":{"title":"Formas īpašības","menu":"Formas īpašības","action":"Darbība","method":"Metode","encoding":"Kodējums"},"hidden":{"title":"Paslēptās teksta rindas īpašības","name":"Nosaukums","value":"Vērtība"},"select":{"title":"Iezīmēšanas lauka īpašības","selectInfo":"Informācija","opAvail":"Pieejamās iespējas","value":"Vērtība","size":"Izmērs","lines":"rindas","chkMulti":"Atļaut vairākus iezīmējumus","required":"Obligāts","opText":"Teksts","opValue":"Vērtība","btnAdd":"Pievienot","btnModify":"Veikt izmaiņas","btnUp":"Augšup","btnDown":"Lejup","btnSetValue":"Noteikt kā iezīmēto vērtību","btnDelete":"Dzēst"},"textarea":{"title":"Teksta laukuma īpašības","cols":"Kolonnas","rows":"Rindas"},"textfield":{"title":"Teksta rindas  īpašības","name":"Nosaukums","value":"Vērtība","charWidth":"Simbolu platums","maxChars":"Simbolu maksimālais daudzums","required":"Obligāts","type":"Tips","typeText":"Teksts","typePass":"Parole","typeEmail":"E-pasts","typeSearch":"Meklēt","typeTel":"Tālruņa numurs","typeUrl":"Adrese"}},"format":{"label":"Formāts","panelTitle":"Rindkopas formāts","tag_address":"Adrese","tag_div":"Parastais (DIV)","tag_h1":"Virsraksts 1","tag_h2":"Virsraksts 2","tag_h3":"Virsraksts 3","tag_h4":"Virsraksts 4","tag_h5":"Virsraksts 5","tag_h6":"Virsraksts 6","tag_p":"Parastais","tag_pre":"Formatēts"},"horizontalrule":{"toolbar":"Ievietot horizontālu Atdalītājsvītru"},"iframe":{"border":"Rādīt rāmi","noUrl":"Norādiet iframe adresi","scrolling":"Atļaut ritjoslas","title":"IFrame uzstādījumi","toolbar":"IFrame","tabindex":"Remove from tabindex"},"image":{"alt":"Alternatīvais teksts","border":"Rāmis","btnUpload":"Nosūtīt serverim","button2Img":"Vai vēlaties pārveidot izvēlēto attēla pogu uz attēla?","hSpace":"Horizontālā telpa","img2Button":"Vai vēlaties pārveidot izvēlēto attēlu uz attēla pogas?","infoTab":"Informācija par attēlu","linkTab":"Saite","lockRatio":"Nemainīga Augstuma/Platuma attiecība","menu":"Attēla īpašības","resetSize":"Atjaunot sākotnējo izmēru","title":"Attēla īpašības","titleButton":"Attēlpogas īpašības","upload":"Augšupielādēt","urlMissing":"Trūkst attēla atrašanās adrese.","vSpace":"Vertikālā telpa","validateBorder":"Apmalei jābūt veselam skaitlim","validateHSpace":"HSpace jābūt veselam skaitlim","validateVSpace":"VSpace jābūt veselam skaitlim"},"indent":{"indent":"Palielināt atkāpi","outdent":"Samazināt atkāpi"},"smiley":{"options":"Smaidiņu uzstādījumi","title":"Ievietot smaidiņu","toolbar":"Smaidiņi"},"language":{"button":"Uzstādīt valodu","remove":"Noņemt valodu"},"link":{"acccessKey":"Pieejas taustiņš","advanced":"Izvērstais","advisoryContentType":"Konsultatīvs satura tips","advisoryTitle":"Konsultatīvs virsraksts","anchor":{"toolbar":"Ievietot/Labot iezīmi","menu":"Labot iezīmi","title":"Iezīmes uzstādījumi","name":"Iezīmes nosaukums","errorName":"Lūdzu norādiet iezīmes nosaukumu","errorWhitespace":"Anchor name cannot contain space characters","remove":"Noņemt iezīmi"},"anchorId":"Pēc elementa ID","anchorName":"Pēc iezīmes nosaukuma","charset":"Pievienotā resursa kodējums","cssClasses":"Stilu saraksta klases","download":"Piespiedu ielāde","displayText":"Attēlot tekstu","emailAddress":"E-pasta adrese","emailBody":"Ziņojuma pamatteksts","emailSubject":"Ziņojuma tēma","id":"ID","info":"Saites informācija","langCode":"Valodas kods","langDir":"Valodas lasīšanas virziens","langDirLTR":"No kreisās uz labo (LTR)","langDirRTL":"No labās uz kreiso (RTL)","menu":"Rediģēt saiti","name":"Nosaukums","noAnchors":"(Šajā dokumentā nav iezīmju)","noEmail":"Lūdzu, ievadiet e-pasta adresi","noUrl":"Lūdzu, ievadiet saites URL","noTel":"Lūdzu, ievadiet tālruņa numuru","other":"<cits>","phoneNumber":"Tālruņa numurs","popupDependent":"Atkarīgs (Netscape)","popupFeatures":"Uznirstošā loga nosaukums īpašības","popupFullScreen":"Pilnā ekrānā (IE)","popupLeft":"Kreisā koordināte","popupLocationBar":"Atrašanās vietas josla","popupMenuBar":"Izvēlnes josla","popupResizable":"Mērogojams","popupScrollBars":"Ritjoslas","popupStatusBar":"Statusa josla","popupToolbar":"Rīku josla","popupTop":"Augšējā koordināte","rel":"Relācija","selectAnchor":"Izvēlēties iezīmi","styles":"Stils","tabIndex":"Ciļņu indekss","target":"Mērķis","targetFrame":"<ietvars>","targetFrameName":"Mērķa ietvara nosaukums","targetPopup":"<uznirstošā logā>","targetPopupName":"Uznirstošā loga nosaukums","title":"Saite","toAnchor":"Iezīme šajā lapā","toEmail":"E-pasts","toUrl":"Adrese","toPhone":"Tālrunis","toolbar":"Saite","type":"Saites tips","unlink":"Atsaistīt","upload":"Augšupielādēt"},"list":{"bulletedlist":"Ievietot/noņemt sarakstu ar aizzīmēm","numberedlist":"Ievietot/noņemt numurētu sarakstu"},"liststyle":{"bulletedTitle":"Vienkārša saraksta uzstādījumi","circle":"Aplis","decimal":"Decimālie (1, 2, 3, utt)","disc":"Disks","lowerAlpha":"Mazie alfabēta (a, b, c, d, e, utt)","lowerRoman":"Mazie romāņu (i, ii, iii, iv, v, utt)","none":"Nekas","notset":"<nav norādīts>","numberedTitle":"Numurēta saraksta uzstādījumi","square":"Kvadrāts","start":"Sākt","type":"Tips","upperAlpha":"Lielie alfabēta (A, B, C, D, E, utt)","upperRoman":"Lielie romāņu (I, II, III, IV, V, utt)","validateStartNumber":"Saraksta sākuma numuram jābūt veselam skaitlim"},"magicline":{"title":"Ievietot šeit rindkopu"},"maximize":{"maximize":"Maksimizēt","minimize":"Minimizēt"},"newpage":{"toolbar":"Jauna lapa"},"pagebreak":{"alt":"Lapas pārnesums","toolbar":"Ievietot lapas pārtraukumu drukai"},"pastetext":{"button":"Ievietot kā vienkāršu tekstu","pasteNotification":"Nospied %1 lai ielīmētu. Tavs pārlūks neatbalsta ielīmēšanu ar rīkjoslas pogām vai uznirstošās izvēlnes opciju.","title":"Ievietot kā vienkāršu tekstu"},"pastefromword":{"confirmCleanup":"Teksts, kuru vēlaties ielīmēt, izskatās ir nokopēts no Word. Vai vēlaties to iztīrīt pirms ielīmēšanas?","error":"Iekšējas kļūdas dēļ, neizdevās iztīrīt ielīmētos datus.","title":"Ievietot no Worda","toolbar":"Ievietot no Worda"},"preview":{"preview":"Priekšskatīt"},"print":{"toolbar":"Drukāt"},"removeformat":{"toolbar":"Noņemt stilus"},"save":{"toolbar":"Saglabāt"},"selectall":{"toolbar":"Iezīmēt visu"},"showblocks":{"toolbar":"Parādīt blokus"},"sourcearea":{"toolbar":"HTML kods"},"specialchar":{"options":"Speciālo simbolu uzstādījumi","title":"Ievietot īpašu simbolu","toolbar":"Ievietot speciālo simbolu"},"scayt":{"btn_about":"Par SCAYT","btn_dictionaries":"Vārdnīcas","btn_disable":"Atslēgt SCAYT","btn_enable":"Ieslēgt SCAYT","btn_langs":"Valodas","btn_options":"Uzstādījumi","text_title":"Pārbaudīt gramatiku rakstot"},"stylescombo":{"label":"Stils","panelTitle":"Formatēšanas stili","panelTitle1":"Bloka stili","panelTitle2":"iekļautie stili","panelTitle3":"Objekta stili"},"table":{"border":"Rāmja izmērs","caption":"Leģenda","cell":{"menu":"Šūna","insertBefore":"Pievienot šūnu pirms","insertAfter":"Pievienot šūnu pēc","deleteCell":"Dzēst rūtiņas","merge":"Apvienot rūtiņas","mergeRight":"Apvieno pa labi","mergeDown":"Apvienot uz leju","splitHorizontal":"Sadalīt šūnu horizontāli","splitVertical":"Sadalīt šūnu vertikāli","title":"Šūnas uzstādījumi","cellType":"Šūnas tips","rowSpan":"Apvienotas rindas","colSpan":"Apvienotas kolonas","wordWrap":"Vārdu pārnese","hAlign":"Horizontālais novietojums","vAlign":"Vertikālais novietojums","alignBaseline":"Pamatrinda","bgColor":"Fona krāsa","borderColor":"Rāmja krāsa","data":"Dati","header":"Virsraksts","columnHeader":"Column Header","rowHeader":"Row Header","yes":"Jā","no":"Nē","invalidWidth":"Šūnas platumam jābūt skaitlim","invalidHeight":"Šūnas augstumam jābūt skaitlim","invalidRowSpan":"Apvienojamo rindu skaitam jābūt veselam skaitlim","invalidColSpan":"Apvienojamo kolonu skaitam jābūt veselam skaitlim","chooseColor":"Izvēlēties"},"cellPad":"Rūtiņu nobīde","cellSpace":"Rūtiņu atstatums","column":{"menu":"Kolonna","insertBefore":"Ievietot kolonu pirms","insertAfter":"Ievieto kolonu pēc","deleteColumn":"Dzēst kolonnas"},"columns":"Kolonnas","deleteTable":"Dzēst tabulu","headers":"Virsraksti","headersBoth":"Abi","headersColumn":"Pirmā kolona","headersNone":"Nekas","headersRow":"Pirmā rinda","heightUnit":"height unit","invalidBorder":"Rāmju izmēram jābūt skaitlim","invalidCellPadding":"Šūnu atkāpēm jābūt pozitīvam skaitlim","invalidCellSpacing":"Šūnu atstarpēm jābūt pozitīvam skaitlim","invalidCols":"Kolonu skaitam jābūt lielākam par 0","invalidHeight":"Tabulas augstumam jābūt skaitlim","invalidRows":"Rindu skaitam jābūt lielākam par 0","invalidWidth":"Tabulas platumam jābūt skaitlim","menu":"Tabulas īpašības","row":{"menu":"Rinda","insertBefore":"Ievietot rindu pirms","insertAfter":"Ievietot rindu pēc","deleteRow":"Dzēst rindas"},"rows":"Rindas","summary":"Anotācija","title":"Tabulas īpašības","toolbar":"Tabula","widthPc":"procentuāli","widthPx":"pikseļos","widthUnit":"platuma mērvienība"},"undo":{"redo":"Atkārtot","undo":"Atcelt"},"widget":{"move":"Klikšķina un velc, lai pārvietotu","label":"logrīks %1"},"uploadwidget":{"abort":"Augšupielādi atcēla lietotājs.","doneOne":"Fails veiksmīgi ielādēts.","doneMany":"Veiksmīgi ielādēts %1 fails.","uploadOne":"Ielādāju failu ({percentage}%)...","uploadMany":"Ielādēju failus, {curent} no {max} izpildīts ({percentage}%)..."},"a11yfirsthelp":{"label":"A11yFirst Help","panelTitle":"Learn about A11yFirst features","keyboardShortcutsLabel":"Keyboard Shortcuts","versionLabel":"Version","a11yFirstHelpLabel":"A11yFirst Help: Content Accessibility","a11yFirstHelpTitle":"Information to help authors understand how the A11yFirst features help them make content more accessible to people with disabilites","headingHelp":{"menu":"Heading / Paragraph","label":"Heading / Paragraph","title":"Heading / Paragraph Help","content":"## Heading / Paragraph\n\n### Menu items\n* **H1 – Document title** — Typically should be the first heading in the\n  document and used only once.\n* **H2 – Section title** — Describes a main or top-level section in the\n  document.\n* **H3 to H6 – Subsection title** — Describes a subsection within a top-level\n  section or other subsection of the document.\n* **Normal** — The default paragraph format, typically with significant top\n  and bottom margins.\n* **Preformatted text** — Use this for computer code blocks to maintain spacing\n  and indentation.\n* **Address line** — Use this to type a series of address lines styled in\n  italics and with minimal top and bottom margins. When you press enter at the\n  end of a line, the next line is also an address line.\n\n### About headings\n* The Heading / Paragraph menu only enables the **allowed** heading levels.\n\n* The cursor position relative to other headings in the document determines\nwhich heading levels are allowed.\n\n### About paragraph formats\n* Visual styling for paragraph formats is predetermined by your organization,\nthus freeing up your time and energy for concentrating on the structure and\nmeaning of the content within your document.\n\n### Why headings and paragraph formats are important\n* The purpose of a heading is to label the content that follows it.\n\n* The proper nesting of heading levels improves the ability of all users to\nfind and comprehend information on a page.\n\n* Headings used consistently and in meaningful ways improve Search Engine\nOptimization (SEO).\n\n* Properly nested headings enable people using assistive technologies to easily\nnavigate to each section of a document.\n\n* When paragraph formats are used properly (e.g. *Preformatted* or *Address*),\nthey help users of assistive technologies understand the intended role of the\ncontent.\n\n* Thinking in terms of blocks such as headings and paragraph formats within\nyour document is a higher-level approach to providing structure and semantics\nthat are important for all users.\n\n### More information\n* Documents are easier to read and understand when headings identify the topics\nthey contain.\n\n* Headings make it easier to scan and find topics of interest within a document.\n\n* Heading levels identify the structural relationships between sections of\ncontent in a document.\n\n* Higher-level headings (Levels 1 and 2) identify the main topics of a document\nand lower-level headings (Levels 3, 4, 5 and 6) identify subsections of the\ndocument.\n\n* A subsection is identified by using the next lower-level heading. For\nexample, subsections of Level 2 headings use Level 3 headings, subsections of\nLevel 3 headings use Level 4 headings, and so on to Level 6 headings.\n\n* Break content into subsections when there are two or more ideas or concepts\nthat correspond to the topics covered in the section. Use headings of the same\nlevel to label each subsection.\n\n* Heading levels should **never** be used for inline visual styling of content\n(e.g. larger or smaller font size, bold or italic). Instead, use the `Inline\nStyle` options.\n"},"listHelp":{"menu":"List","label":"List","title":"List Help","content":"## List\n\n### Working with lists\n\n<img style=\"padding: 8px 0 3px 5px\" alt=\"list toolbar buttons\"\nsrc=\"basePath/plugins/a11yfirsthelp/images/list-buttons.png\"/>\n\nUse the toolbar buttons shown above to:\n\n* Insert/Remove Numbered List\n* Insert/Remove Bulleted List\n* Increase Indent\n* Decrease Indent\n\n### List properties via context menu\n\nThe context menu allows further configuration of list properties such as\nnumbering and bullet types by selecting:\n\n* Numbered List Properties\n* Bulleted List Properties\n\nThe context menu can be invoked by positioning the cursor in a list item and:\n\n* right-clicking, using the mouse, or\n* using Mouse Keys on Windows or Mac.\n\n### About lists\n\n* Use a numbered list when the order or sequence of the items is significant.\n* Use a bulleted list when the order of the items is not significant.\n\n### Why lists are important\n\n* Lists convey grouping semantics for related items.\n* Lists may also convey hierarchical structure.\n* When related items are grouped as a list, information about the list is\n  conveyed to screen reader users, including the type of list, the number of\n  items it contains and the sequence number of the current list item.\n"},"imageHelp":{"menu":"Image","label":"Image","title":"Image Help","content":"## Image\n\n### Accessible image descriptions\n\n* People with visual impairments or visual processing disorders need\n  accessible text descriptions of informative images.\n\n* There are two types of accessible descriptions for images: *alternative\n  text* and *long descriptions*.\n\n### Alternative text\n\n* Succinctly describes the content and function of the image for people\n  with visual impairments, in no more than 100 characters\n\n* Is required for informative images (but not for images that are purely\n  decorative)\n\n* Is not visible in the document; it is communicated to screen reader users\n  via the *img* element's *alt* attribute\n\n* For a purely decorative image, select the **‘Image does not require\n  alternative text’** checkbox and leave the alternative text field blank.\n\n### Long descriptions for complex images\n\n* A complex image has informational content that cannot be described adequately\n  by alternative text of 100 characters or less.\n\n* Examples of complex images include charts, graphs, diagrams, scientific\n  photographs and works of art.\n\n* A complex image needs both a concise alternative text description and a\n  longer, more detailed description.\n\n* Accessibility requirements mandate that the long description of a complex\n  image be placed in the document adjacent to the image.\n\n### Adding a long description in the document\n\nFollow these steps when adding a long description of a complex image:\n\n1. Add an adequately detailed description of the image within the document,\n   either just before or after the image (or both).\n\n1. In answer to the question **‘Is a long description needed, and if so,\n   where will it be located’**, select one of the following:\n       * Yes; in the document before the image\n       * Yes; in the document after the image\n       * Yes; in the document before and after the image\n\nBy specifying the location of the long description relative to the image,\nscreen reader users will be informed of its existence and location in the\ndocument. (This information is appended to the alternative text.)\n\n### Insert a caption text box below the image\n\n* A **caption** is an optional visual label supported by CKEditor for an image.\n  It provides an additional way to describe an image that is immediately below\n  and proximate to the image.\n\n* The caption content is specified and is editable in the text box just below\n  the image, once it has been inserted in the document.\n\n* From an accessibility perspective the *caption* and the *alternative text*\n  should not be the same, but instead should complement each other.\n\n* Using the caption creates a *figcaption* element contained in a *figure*\n  element. The *figure* element also contains the *img* element.\n\n### Writing effective alternative text\n\nThe following are based on <a href=\"https://webaim.org\" target=\"_resource\">\nWebAIM</a>'s guidelines for alternative text:\n\n* **Be accurate and equivalent** in presenting the same *content* and\n  *function* of the image.\n\n* When **images are used as links**, the alternative text should describe the\n  target of the link.\n\n* **Be succinct.** This means the correct content and function of the image\n  should be presented as succinctly as is appropriate. Typically no more than\n  a few words are necessary, though rarely a short sentence or two may be\n  appropriate. The length should not exceed 100 characters.\n\n* **Do NOT be redundant** or provide the same information as text that is\n  already part of the document.\n\n* **Do NOT use the phrases “image of ...” or “graphic of ...”** to describe\n  the image. Assistive technologies notify the user of the image.  It is your\n  job to describe the purpose or the content of the image.  If the image is a\n  photograph or illustration, etc. of important content, it may be useful to\n  include this in the alternative text.\n\n* **Do NOT include file names or sizes** as part of the alternative text.\n\n### Why image descriptions are important\n\nAdding text descriptions of images is an important part of making documents\naccessible to the visually impaired who use assistive devices such as screen\nreaders and magnifiers, and to people with visual processing disorders, which\nmake especially complex images more difficult to understand.\n\nWhen the user cannot see all or part of an image, assistive technologies will\nread or display its alternative text description. This is especially important\nwhen the image conveys information that is required for the user to fully\nunderstand the information in the document.\n\nFor people with visual processing disorders, a detailed description of a\ncomplex image helps them to more quickly or completely understand the\ninformation being conveyed by the image.\n\n### More information\n\n* <a href=\"https://accessibility.psu.edu/images/alttext/\"\ntarget=\"_resource\">Penn State: Image ALT Text</a>\n\n* <a href=\"https://webaim.org/techniques/alttext/\"\ntarget=\"_resource\">WebAIM: Alternative Text</a>\n\n* <a href=\"https://www.w3.org/WAI/tutorials/images/\"\ntarget=\"_resource\">W3C Web Accessibility Image Tutorial</a>\n\n* <a href=\"http://diagramcenter.org/\" target=\"_resource\">Diagram Center</a>\n"},"inlineStyleHelp":{"menu":"Character Style","label":"Character Style","title":"Character Style Help","content":"## Character Style\n\n### Working with character styles\n\n* To apply a character style to existing text, select a range of text and then\nchoose an option from the menu.\n\n* To apply a character style to text you are about to type, choose an option\nfrom the menu and begin typing. The style will continue to be applied until\nyou choose another option or move the cursor to a different point in the\ndocument.\n\n* Multiple character styles can be applied to selected text.\n\n### About character styles\n\n* Character styles have a different purpose than paragraph formats. They are\nused at a lower level to highlight words or phrases within blocks of text.\n\n* Character styles, when used properly, help screen reader users better\nunderstand the types and meanings of lower-level stylistic changes within\nblocks of text.\n\n### Character styles vs. headings, lists and paragraph formats\n\n* Thinking in terms of headings, lists and paragraph formats first, and then\nusing character styles to emphasize key words or phrases within text blocks,\nresults in documents that are easier to read and understand.\n\n* When headings, lists and paragraph formats are considered as primary, and\ncharacter styles secondary, many visual styling decisions can be avoided, as\nthey are already made by default.\n\n* When character styles are used to change the styling of blocks of text\nwithout regard to whether the block is a heading, list item or other type of\nparagraph format, it makes the document more difficult to read and understand\nwithin the context of the website.\n\n* Using headings, lists, paragraph formats and character styles properly will\nmake it easier for you to maintain stylistic consistency.\n"},"linkHelp":{"menu":"Link","label":"Link","title":"Link Help","content":"## Link\n\n### Display Text\n\nProviding accessible *Display Text* is straightforward if you keep the\nfollowing guidelines in mind:\n\n1. The *Display Text* for a link should describe the target of the link.\n\n1. Do not use ambiguous text, such as “Click Here” or “More”.\n\n1. Do not begin the *Display Text* with redundant words or phrases such as\n   “Link” or “Link to”.\n\n1. Be consistent: Links to the same URL or e-mail address should have the same\n   *Display Text*.\n\n1. In most cases, it is best not to use the link URL or e-mail address as the\n   *Display Text*.\n\n### About links\n\n* Screen reader users often use the “List of Links” feature to identify and\n  navigate to links on a page. When links are presented as a list,  using\n  descriptive *Display Text* becomes even more important since understanding\n  the target of each link no longer benefits from its original context within\n  the document.\n\n* Screen reader users often use the “Search” feature to find links on a page\n  based on keywords they would expect to find in the *Display Text* of the\n  links. Thus the more descriptive the link *Display Text*, the more effective\n  the search feature will be in finding relevant links.\n\n* Usable and accessible *Display Text* should be descriptive, unique and start\n  with keywords (NNG).\n\n* The *Display Text* for links is like a sign post. It should tell you what\n  you’ll find when you follow it (NOMENSA).\n\n### Why links are important\n\n* Descriptive link text makes it easier for everyone to find and follow links\n  on a page that are of interest to them.\n\n* Descriptive link text is especially important for people using screen\n  readers, who typically only hear the display text spoken to them through\n  speech synthesis and do not \"see\" the link in the context of other content\n  on the page.\n\n* When URLs, e-mail addresses or other ambiguous text are used as the display\n  text for a link, it is impossible in many cases, and much more difficult in\n  the remaining cases, for screen reader users to find and follow links of\n  interest to them.\n\n### More information\n\n* <a href=\"https://www.nngroup.com/articles/writing-links/\"\ntarget=\"_resource\">NNG: Writing Hyperlinks: Salient, Descriptive, Start with\nKeyword</a>\n\n* <a href=\"https://www.nomensa.com/blog/2011/writing-good-link-text\"\ntarget=\"_resource\">Nomensa: How to write good link text</a>\n\n* <a href=\"https://accessibility.umn.edu/core-skills/hyperlinks\"\ntarget=\"_resource\">Accessible U: Hyperlinks (Good and Bad Examples)</a>\n"},"gettingStarted":{"menu":"Getting Started","label":"Getting Started","title":"Getting Started with A11yFirst","content":"## Getting Started with A11yFirst\n\n### What is A11yFirst?\n\nBefore you begin using the A11yFirst editor, it is important to know what\nmakes it different from other editors. The name *A11yFirst* hints at some\nof these differences.\n\n*A11y* is shorthand for *accessibility* (*a* + 11 letters + *y*), and\naccessibility in the context of document authoring is about making the\ninformation that documents contain perceivable and understandable by everyone,\nincluding people with disabilities.</p>\n\n### Commitment to accessibility\n\nYour organization, by hosting the A11yFirst editor within its content\nmanagement system, has made a commitment to accessibility because (1) it\nremoves barriers that people with visual, auditory, learning and other\ndisabilities may experience in their use of web information and communication\ntechnologies and (2) it is required by law.\n\nBy following accessibility guidelines when creating public-facing documents,\nyou are fulfilling your role in this commitment.\n\n### Document accessibility\n\nSome of the main components within a document that are important for\naccessibility are:\n\n* **Headings** — These provide titles for the sections and subsections of\ncontent within your document, as well as a title for the document itself.\n\n* **Lists** — By using the list feature, the items in a list are grouped\ntogether and information about the grouping can be conveyed to users of\nassistive technologies.\n\n* **Links** — The text component of a link should describe its target, i.e.,\nthe web site, page or section that will be displayed if you activate the link.\n\n* **Images** — When an image with informational content is included within a\ndocument, a short text description (also known as ‘alt text’) allows screen\nreader users to obtain a concise description of the image.\n\n* **Tables** — By using the table feature to organize tabular data and provide row\nand column headers, users of assistive technologies gain the ability to easily\nnavigate and understand structural relationships within the data.\n\n### A different way of thinking\n\nThe way you think about the process or workflow of creating and editing\ndocuments can make a significant difference in whether the end result, your\nfinished document, is accessible.\n\nFor example, rather than thinking about stylistic considerations such as font\nsizes and colors first, if you make the structure of your document a primary\nconsideration, by breaking it down into sections and subsections and giving\neach of these a meaningful title, you will end up with a document that will\nbe easier for all users to navigate and understand, including people with\ndisabilities.\n"},"aboutA11yFirst":{"menu":"About A11yFirst","label":"About A11yFirst","title":"Description of A11yFirst Project","content":"## About A11yFirst\n\n### Project Description & Goals\n\nThe A11yFirst Project is a collection of modifications to CKEditor, an\nHTML-embedded WYSIWYG editor typically used within content management\nsystems. Its goal is to make the process of creating and editing web documents\none that proactively results in accessible content.\n\nIn the past, authors have had to rely upon remediation tools used at the end\nof the authoring process that ‘fix’ accessibility problems without offering\nmuch guidance on how to prevent them. The A11yFirst editor takes a different\napproach.\n\nFor example, by prompting the author to provide information regarding links\nand images as they are added to the document, accessibility problems are not\nonly avoided, but authors learn on a feature-by-feature basis some of the\nimportant requirements for accessible content.\n\nOther design features in A11yFirst promote the use of blocks such as headings\nand lists that carry with them semantics that are communicated to screen\nreader users and that result in documents that are more easily navigated and\nunderstood by all readers.\n\n### Project Information\n\n* Version: %version\n\n* GitHub Repositories: <a href=\"https://github.com/a11yfirst\"\ntarget=\"_resource\">https://github.com/a11yfirst</a>\n\n### Contributors\n\n* Lucy Chang     (UX, Usability Testing)\n* Jon Gunderson  (Requirements, Development, Usability Testing,\n  Project Management)\n* Nicholas Hoyt  (UX, UI Design, Development, Usability Testing,\n  Project Management)\n* JaEun Jemma Ku (Requirements, Usability Testing, UI Design,\n  Project Management)\n* Eileen Lopez   (UX, Usability Testing)\n* Mark McCarthy  (UX, Usability Testing)\n* Robert Slater  (Requirements)\n* Dena Strong    (UX, Usability Testing)\n\n### Sponsors\n\n* Disability Resources and Educational Services (DRES), College of Applied\n  Health Sciences (AHS), University of Illinois at Urbana-Champaign\n* Illinois Extension, College of Agricultural, Consumer and Environmental\n  Sciences (ACES), University of Illinois at Urbana-Champaign\n* The University Library, Innovation Fund (Jemma Ku, P.I.), University of\n  Illinois at Urbana-Champaign\n* Administrative Information Technology Services (AITS), University of\n  Illinois at Urbana-Champaign\n* School of Information Sciences (iSchool), University of Illinois at\n  Urbana-Champaign\n\n### Acknowledgements\n\nMany of the ideas and motivations for the A11yFirst Project were the result\nof work done previously by a group of software developers at the Illinois\nDepartment of Human Services (DHS), led by Mike Scott, who created the OneNet\ncontent management system, which includes as its centerpiece an accessible\nWYSIWYG editor.\n\nThe OneNet CMS has been in use by the Illinois DHS since 2006 to promote\naccessible authoring for their intranet and main website.\n\nMr. Scott also participated in the requirements gathering phase of the\nA11yFirst Project.\n"}},"codemirror":{"copyright":"Copyright CodeMirror © Marijn Haverbeke. All rights reserved.","dlgTitle":"About CodeMirror Source Plugin","moreInfoShortcuts":"Available Shortcuts","moreInfoShortcuts1":"<strong>CTRL + K</strong> to comment the currently selected text","moreInfoShortcuts2":"<strong>CTRL + SHIFT + K</strong> to uncomment currently selected text","moreInfoShortcuts3":"<strong>CTRL + ALT + K</strong> to auto format currently selected text","moreInfoShortcuts4":"<strong>CTRL + Q</strong> Expand / Collapse Code Block","moreInfoShortcuts5":"<strong>CTRL + F</strong> to perform a search","moreInfoShortcuts6":"<strong>CTRL + G</strong> to find next","moreInfoShortcuts7":"<strong>CTRL + SHIFT + G</strong> to find previous","moreInfoShortcuts8":"<strong>CTRL + SHIFT</strong> to find and replace","moreInfoShortcuts9":"<strong>CTRL + SHIFT + R</strong> to find and replace all","toolbar":"HTML kods","searchCode":"Search Source (CTRL + F)","replaceCode":"Replace Code (CTRL + SHIFT + F)","autoFormat":"Format Selection (CTRL + ALT + K)","commentSelectedRange":"Comment Selection (CTRL + K)","uncommentSelectedRange":"Uncomment Selection (CTRL + SHIFT + K)","autoCompleteToggle":"Enable/Disable HTML Tag Autocomplete"},"emoji":{"searchPlaceholder":"Search emoji…","searchLabel":"Input field responsible for searching and filtering emoji inside panel.","navigationLabel":"Groups navigation for emoji sections.","title":"Emoji List","groups":{"people":"People","nature":"Nature and animals","food":"Food and drinks","travel":"Travel and places","activities":"Activities","objects":"Objects","symbols":"Symbols","flags":"Flags"}},"html5video":{"button":"Insert HTML5 video","title":"HTML5 video","infoLabel":"Video info","allowed":"Allowed file extensions: MP4, WebM, Ogv","urlMissing":"Video source URL is missing.","videoProperties":"Video properties","upload":"Upload","btnUpload":"Send it to the server","advanced":"Advanced","autoplay":"Autoplay?","allowdownload":"Allow download?","advisorytitle":"Advisory title","yes":"Yes","no":"No","loop":"Loop?","responsive":"Responsive width","controls":"Show controls","poster":"Thumbnail"},"sourcedialog":{"toolbar":"HTML kods","title":"HTML kods"}};